<!DOCTYPE html>
<html lang="en" dir="<?php echo text_dir(); ?>">

<head>

   <!-- Title  -->
    <?php $settings = get_settings(); ?>
    
    <?php
// Get the current slug from the URL
$current_uri = $_SERVER['REQUEST_URI'];
$slug = trim($current_uri, '/'); // Remove leading/trailing slashes
$slug_parts = explode('/', $slug); // Split by slash
$last_slug = end($slug_parts); // Get the last part
$og_imge = '';
// Define default Open Graph meta description
$og_title = 'Aversa Outdoor | Landscaping & Outdoor Living';
$og_description = 'Aversa Outdoor provides professional landscaping, outdoor living spaces, turf installation, patios, and hardscaping services in Bradenton, FL. Transform your outdoor space.';

$title_suffix = '';
$meta_description = '';

// Check if the URL corresponds to a post
if (isset($slug_parts[1]) && $slug_parts[1] == 'post') {
    // Get the post slug after '/post/'
    $post_slug = isset($slug_parts[2]) ? $slug_parts[2] : '';
    
    // Make the slug more readable: Replace dashes with spaces, and capitalize
    $title_suffix = ucfirst(str_replace('-', ' ', $post_slug));
    $title_suffix = ucwords($title_suffix);
    
    
    // Set dynamic title and description based on the post slug
    $meta_description = "Read more about " . $title_suffix . " on Aversa Outdoor Blog Page.";
    $og_title = $title_suffix;
    $og_description = $meta_description;
    echo('<title>' . $title_suffix . '</title>'); 
    
     $current_url = 'https://aversaoutdoor.com' . $_SERVER['REQUEST_URI'];
    
    // Get actual post data for image and other details
    $CI =& get_instance();
    $CI->load->model('common_model');
    $actual_post = $CI->common_model->get_post_details($post_slug);
    
    if ($actual_post && !empty($actual_post->image)) {
        $post_image = 'https://aversaoutdoor.com/' . ltrim($actual_post->image, '/');
        $post_title = $actual_post->title;
        $post_excerpt = strip_tags(substr($actual_post->details, 0, 160)) . '...';
        $meta_description = $post_excerpt;
        $og_description = $post_excerpt;
                $post_date = date('c', strtotime($actual_post->created_at)); // Convert to ISO 8601 format

        // Update the meta description with actual post content
        echo('<meta name="description" content="' . htmlspecialchars($meta_description, ENT_QUOTES, 'UTF-8') . '" />');
    } else {
        $post_image = 'https://aversaoutdoor.com/uploads/home.webp'; // Default blog image
        $post_title = $title_suffix;
        $post_excerpt = $meta_description;
                $post_date = date('c'); // Current date as fallback
echo('<meta name="description" content="' . htmlspecialchars($meta_description, ENT_QUOTES, 'UTF-8') . '" />');
    }
    
    $current_date = date('c'); // Current date in ISO 8601 format
    ?>
    <script type="application/ld+json">
    {
      "@context": "https://schema.org",
      "@graph": [
        {
          "@type": "WebPage",
          "@id": "<?= $current_url ?>#webpage",
          "url": "<?= $current_url ?>",
          "name": "<?= htmlspecialchars($post_title, ENT_QUOTES, 'UTF-8') ?>",
          "description": "<?= htmlspecialchars($post_excerpt, ENT_QUOTES, 'UTF-8') ?>",
          "thumbnailUrl": "<?= $post_image ?>",
          "datePublished": "<?= $post_date ?>",
          "dateModified": "<?= $current_date ?>",
          "inLanguage": "en-US",
          "isPartOf": {
            "@id": "https://aversaoutdoor.com/#website"
          },
          "primaryImageOfPage": {
            "@id": "<?= $current_url ?>#primaryimage"
          },
          "breadcrumb": {
            "@id": "<?= $current_url ?>#breadcrumb"
          },
          "author": {
            "@id": "https://aversaoutdoor.com/#/schema/person/joshuajohnson"
          },
          "potentialAction": {
            "@type": "ReadAction",
            "target": "<?= $current_url ?>"
          }
        },
        {
          "@type": "ImageObject",
          "@id": "<?= $current_url ?>#primaryimage",
          "contentUrl": "<?= $post_image ?>",
          "url": "<?= $post_image ?>",
          "caption": "<?= htmlspecialchars($post_title, ENT_QUOTES, 'UTF-8') ?> - Aversa Outdoor",
          "inLanguage": "en-US",
          "width": 2240,
          "height": 1260
        },
        {
          "@type": "BreadcrumbList",
          "@id": "<?= $current_url ?>#breadcrumb",
          "itemListElement": [
            {
              "@type": "ListItem",
              "position": 1,
              "name": "Home",
              "item": "https://aversaoutdoor.com/"
            },
            {
              "@type": "ListItem",
              "position": 2,
              "name": "Blog",
              "item": "https://aversaoutdoor.com/blogs"
            },
            {
              "@type": "ListItem",
              "position": 3,
              "name": "<?= htmlspecialchars($title_suffix, ENT_QUOTES, 'UTF-8') ?>"
            }
          ]
        },
        {
          "@type": "Person",
          "@id": "https://aversaoutdoor.com/#/schema/person/joshuajohnson",
          "name": "Joshua Johnson",
          "url": "https://aversaoutdoor.com/about",
          "image": {
            "@type": "ImageObject",
            "contentUrl": "https://aversaoutdoor.com/uploads/joshuajohnson.webp",
            "url": "https://aversaoutdoor.com/uploads/joshuajohnson.webp",
            "caption": "Posted by Joshua Johnson",
            "inLanguage": "en-US"
          },
          "jobTitle": "Landscaping",
          "worksFor": {
            "@id": "https://aversaoutdoor.com/#organization"
          }
        },
        {
          "@type": "Article",
          "@id": "<?= $current_url ?>#article",
           "headline": "<?= htmlspecialchars($post_title, ENT_QUOTES, 'UTF-8') ?>",
          "description": "<?= htmlspecialchars($post_excerpt, ENT_QUOTES, 'UTF-8') ?>",
          "image": "<?= $post_image ?>",
          "datePublished": "<?= $post_date ?>",
          "dateModified": "<?= $current_date ?>",
          "author": {
            "@id": "https://aversaoutdoor.com/#/schema/person/joshuajohnson"
          },
          "publisher": {
            "@id": "https://aversaoutdoor.com/#organization"
          },
          "mainEntityOfPage": {
            "@id": "<?= $current_url ?>#webpage"
          },
          "articleSection": "Landscaping",
          "keywords": "landscaping, outdoor living, bradenton, Holmes Beach, Longboat Key, turf installation"
        }
      ]
    }
    </script>
    <?php
} else {
    // Handle specific pages without switch
    if ($last_slug == 'contact') {
        $title_suffix = 'Contact Aversa Outdoor | Landscaping & Outdoor Living';
        $meta_description = 'Get in touch with Aversa Outdoor for landscaping, hardscaping, turf, and outdoor living services. Call or message our Bradenton team to start your project.';
        $og_image = '';
    }  
    elseif ($last_slug == 'login' || $last_slug == 'register') {
        $title_suffix = 'Login | Register | Aversa Outdoor';
        $meta_description = ' '; 
    }
    elseif ($last_slug == 'terms-conditions') {
        $title_suffix = 'Terms and Conditions | Aversa Outdoor';
        $meta_description = 'You may find our companies terms and conditions on the terms and conditions page.'; 
    } 
    elseif ($last_slug == 'faqs') {
        $title_suffix = 'Landscaping & Outdoor Living FAQs | Aversa Outdoor';
        $meta_description = 'Find answers to common questions about landscaping, turf, hardscaping, outdoor living spaces, project timelines, pricing, and maintenance with Aversa Outdoor.';
        $og_image = '';
    } 
    elseif ($last_slug == 'blogs') {
        $title_suffix = 'Landscaping & Outdoor Living Blog | Aversa Outdoor';
        $meta_description = 'Explore outdoor living tips, landscaping ideas, turf guides, and design inspiration from Aversa Outdoor. Learn how to upgrade your yard with simple, beautiful solutions.';
        $og_image = '';
    } 
        elseif ($last_slug == 'services') {
        $title_suffix = 'Landscaping & Outdoor Services | Aversa Outdoor';
        $meta_description = 'Explore Aversa Outdoor’s full range of landscaping, hardscaping, turf installation, patio building, and outdoor living services.';
        $og_image = '';
        ?>
         

        
        <?php
    }  
    elseif ($last_slug == 'artificial-turf-installation') {
        $title_suffix = 'Artificial Turf Installation Services | Aversa Outdoor';
        $meta_description = 'Professional artificial turf installation for homes and outdoor spaces. Low-maintenance, long-lasting, and designed for year-round durability. Get a free quote.';
        $og_image = '';
        ?>
         

        
        <?php
    }  
    elseif ($last_slug == 'concrete-masonry') {
        $title_suffix = 'Concrete Masonry Services | Patios, Walkways & Hardscaping';
        $meta_description = 'Strong, clean, long-lasting concrete masonry for patios, walkways, steps, and custom hardscaping. Aversa Outdoor builds durable outdoor spaces that look great and last.';
        $og_image = '';
        ?>
         

        
        <?php
    }  
    elseif ($last_slug == 'driveway-landscaping') {
        $title_suffix = 'Driveway Landscaping Services | Clean Borders & Curb Appeal';
        $meta_description = 'Upgrade your driveway with clean borders, plants, stone accents, and modern designs. Aversa Outdoor creates beautiful driveway landscaping that boosts curb appeal.';
        $og_image = '';
        ?>
         

        
        <?php
    }  
    elseif ($last_slug == 'outdoor-living-spaces') {
        $title_suffix = 'Outdoor Living Spaces | Patios, Seating & Backyard Design';
        $meta_description = 'Custom outdoor living spaces including patios, seating areas, walkways, and backyard designs. Built for comfort, style, and everyday use. Free quotes available.';
        $og_image = '';
        ?>
         

        
        <?php
    }  
    elseif ($last_slug == 'driveway-landscaping') {
        $title_suffix = 'Driveway Landscaping Services | Clean Borders & Curb Appeal';
        $meta_description = 'Upgrade your driveway with clean borders, plants, stone accents, and modern designs. Aversa Outdoor creates beautiful driveway landscaping that boosts curb appeal.';
        $og_image = '';
        ?>
         

        
        <?php
    }  
    elseif ($last_slug == 'driveway-walkway-paving') {
        $title_suffix = 'Driveway & Walkway Paving Services | Strong & Stylish Paving';
        $meta_description = 'Professional driveway and walkway paving built for strength, style, and long-lasting curb appeal. Choose durable, clean paving designs that upgrade your home.';
        $og_image = '';
        ?>
         

        
        <?php
    }  
    elseif ($last_slug == 'landscape-design') {
        $title_suffix = 'Landscape Design Services | Clean & Modern Outdoor Layouts';
        $meta_description = 'Professional landscape design with clean, modern layouts built for beauty and function. Custom plans that enhance curb appeal and fit your home’s style.';
        $og_image = '';
        ?>
         

        
        <?php
    }  
    elseif ($last_slug == 'outdoor-fireplaces') {
        $title_suffix = 'Outdoor Fireplace Installation | Custom Backyard Fireplaces';
        $meta_description = 'Custom outdoor fireplaces designed for warmth, comfort, and style. Built to match your home and create a cozy outdoor living space.';
        $og_image = '';
        ?>
         

        
        <?php
    }  
    elseif ($last_slug == 'drainage-grading') {
        $title_suffix = 'Drainage & Grading Services | Yard Water Control Solutions';
        $meta_description = 'Professional drainage and grading solutions that prevent flooding, erosion, and standing water. Protect your home with long-lasting water control systems.';
        $og_image = '';
        ?>
         

        
        <?php
    }
    elseif ($last_slug == 'patio-building') {
        $title_suffix = 'Patio Building Services | Custom Outdoor Patios';
        $meta_description = 'Professional patio building for outdoor living. Strong, stylish patios built for durability, comfort, and everyday use. Get a custom design and free quote.';
        $og_image = '';
        ?>
         

        
        <?php
    }  
    elseif ($last_slug == 'driveway-construction') {
        $title_suffix = 'Driveway Construction Services | Durable Driveway Builds';
        $meta_description = 'Professional driveway construction with clean finishes and long-lasting strength. Concrete, paver, and stone driveways built for everyday use. Free quotes available.';
        $og_image = '';
        ?>
         

        
        <?php
    }
    elseif ($last_slug == 'stone-retaining-walls') {
        $title_suffix = 'Stone Retaining Walls | Natural, Strong & Long-Lasting';
        $meta_description = 'Natural stone retaining walls built for strength, beauty, and long-lasting support. Custom designs, expert installation, and durable materials. Free quotes available.';
        $og_image = '';
        ?>
         

        
        <?php
    }  
    elseif ($last_slug == 'retaining-walls') {
        $title_suffix = 'Retaining Wall Construction | Strong & Stylish Designs';
        $meta_description = 'Strong and stylish retaining walls built for support and clean outdoor design. Block, stone, and concrete options. Long-lasting builds. Free quotes available.';
        $og_image = '';
        ?>
         

        
        <?php
    }  
    elseif ($last_slug == 'walls-and-steps') {
        $title_suffix = 'Walls & Steps Installation | Custom Outdoor Structures';
        $meta_description = 'Custom walls and steps built for strength, style, and outdoor flow. Safe pathways, clean design, and long-lasting support for your yard. Free quotes available.';
        $og_image = '';
        ?>
         

        
        <?php
    }  
     elseif ($last_slug == 'concrete-work') {
        $title_suffix = 'Concrete Work Services | Patios, Slabs & Custom Builds';
        $meta_description = 'Professional concrete work for patios, slabs, walkways, driveways, and custom outdoor builds. Strong foundations and smooth finishes. Get a free quote.';
        $og_image = '';
        ?>
         

        
        <?php
    }  
    elseif ($last_slug == 'land-clearing') {
        $title_suffix = 'Tree Removal Services | Safe & Professional Removal';
        $meta_description = 'Safe and efficient tree removal for dead, hazardous, or unwanted trees. Full cleanup, careful removal, and protection for your home and yard.';
        $og_image = '';
        ?>
         

        
        <?php
    }  
    elseif ($last_slug == 'new-construction-landscaping') {
        $title_suffix = 'New Construction Landscaping | Complete Outdoor Design';
        $meta_description = 'Full landscaping for new homes, including planting, rock, turf, grading, and clean modern layouts. Start-to-finish outdoor design and installation.';
        $og_image = '';
        ?>
         

        
        <?php
    }  
    elseif ($last_slug == 'excavation') {
        $title_suffix = 'Excavation & Site Preparation Services | Grading & Digging';
        $meta_description = 'Professional excavation, grading, and site preparation for outdoor projects. Safe digging, smooth leveling, and strong foundations for landscaping and construction.';
        $og_image = '';
        ?>
         

        
        <?php
    }  
    elseif ($last_slug == 'outdoor-planting') {
        $title_suffix = 'Outdoor Planting Services | Clean, Modern Plant Layouts';
        $meta_description = 'Professional outdoor planting with fresh, clean layouts that fit your home’s style. High-quality plant design and installation for simple, modern outdoor spaces.';
        $og_image = '';
        ?>
         

        
        <?php
    }  
    else {
        $title_suffix = 'Aversa Outdoor | Landscaping & Outdoor Living';
        $meta_description = 'Aversa Outdoor provides professional landscaping, outdoor living spaces, turf installation, patios, and hardscaping services. Transform your outdoor space.';
        $og_imge = '';
        ?>
    <script type="application/ld+json">
    {
  "@context": "https://schema.org",
  "@type": "BreadcrumbList",
  "name": "Home",
  "itemListElement": [
    {
      "@type": "ListItem",
      "position": 1,
      "name": "Home",
      "item": "https://aversaoutdoor.com"
    }
  ]
}

    </script> 


        <?php
    }
    
    // Default title and description for other pages
    echo('<title>' . $title_suffix . '</title>');
    echo('<meta name="description" content="' . htmlspecialchars($meta_description, ENT_QUOTES, 'UTF-8') . '" />');
        echo('<meta name="robots" content="index, follow, max-snippet:-1, max-image-preview:large, max-video-preview:-1" />');

}

// Open Graph meta tags
echo '<meta property="og:title" content="' . htmlspecialchars($title_suffix, ENT_QUOTES, 'UTF-8') . '" />';
echo '<meta property="og:type" content="website" />';
echo '<meta property="og:image" content="' . $og_imge . '" />';
echo '<meta property="og:url" content="https://aversaoutdoor.com' . htmlspecialchars($_SERVER['REQUEST_URI'], ENT_QUOTES, 'UTF-8') . '" />';

echo '<meta property="og:description" content="' . htmlspecialchars($meta_description, ENT_QUOTES, 'UTF-8') . '" />';
echo '<meta name="twitter:card" content="summary_large_image" />';
echo '<meta name="twitter:title" content="' . $title_suffix . '" />';
echo '<meta name="twitter:description" content="' . htmlspecialchars($meta_description, ENT_QUOTES, 'UTF-8') . '" />';
echo '<meta property="twitter:site" content="https://aversaoutdoor.com' . htmlspecialchars($_SERVER['REQUEST_URI'], ENT_QUOTES, 'UTF-8') . '" />';
echo '<meta name="twitter:image" content="' . $og_imge . '" />';
?>
<?php
// Get the current URL path
$uri = $_SERVER['REQUEST_URI'];

// Check if it ends with .html
if (substr($uri, -5) === '.html') {
    // Remove .html
    $cleanUrl = substr($uri, 0, -5);

    // Get protocol and host
    $protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off') ? "https://" : "http://";
    $host = $_SERVER['HTTP_HOST'];

    // Redirect permanently
    header("HTTP/1.1 301 Moved Permanently");
    header("Location: {$protocol}{$host}{$cleanUrl}");
    exit();
}
?>
<script type="application/ld+json">
{
  "@context": "https://schema.org",
  "@type": "Organization",
  "@id": "https://aversaoutdoor.com/",
  "name": "Aversa Outdoor",
  "url": "https://aversaoutdoor.com",
  "logo": "https://aversaoutdoor.com/uploads/logo-removebg-preview.png",
  "image": "https://aversaoutdoor.com/uploads/home.webp",
  "description": "Aversa Outdoor crafts environmentally responsible landscapes that are as elegant as they are inviting. We transform your property into a visual masterpiece, using sustainable practices to create a space that thrives in harmony with nature. Let Aversa Outdoor cultivate your dream landscape. Aversa Outdoor is more than just a landscaping company; It’s a family-owned business with three generations dedicated to creating exceptional outdoor environments. Established in New York, and flourishing in Florida since 2019, our story is one of deep roots with an unwavering commitment to quality, and a passion for transforming properties into havens of beauty and enjoyment. We believe in supporting local communities and sourcing only premium materials.",
  "telephone": "+1-941-274-1505",
  "email": "contact@aversaoutdoor.com",
  "address": {
    "@type": "PostalAddress",
    "streetAddress": "2520 Manatee Ave E Unit 1",
    "addressLocality": "Bradenton",
    "addressRegion": "FL",
    "postalCode": "34208",
    "addressCountry": "US"
  },
  "sameAs": [
    "https://www.facebook.com/AversaOutdoor/",
    "https://www.instagram.com/aversa_outdoor/"
  ],
  "contactPoint": {
    "@type": "ContactPoint",
    "telephone": "+1-941-274-1505",
    "contactType": "customer service",
    "areaServed": "US",
    "availableLanguage": "English"
  }
}
</script>

<link rel="canonical" href="https://aversaoutdoor.com<?php echo htmlspecialchars($_SERVER['REQUEST_URI'], ENT_QUOTES, 'UTF-8'); ?>" />

        <meta name="keywords" content="<?php echo lang_value()->keywords ?>"> 


    <meta http-equiv="x-ua-compatible" content="ie=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1">

    <meta name="theme-color" content="#286efb" />
    <meta name="msapplication-navbutton-color" content="#286efb" />
    <meta name="apple-mobile-web-app-status-bar-style" content="#286efb" />

    <!-- Favicons-->
    <link rel="icon" href="<?php echo base_url($settings->favicon) ?>">
    <link rel="apple-touch-icon" href="<?php echo base_url($settings->favicon) ?>">
    <link rel="apple-touch-icon" sizes="72x72" href="<?php echo base_url($settings->favicon) ?>">
    <link rel="apple-touch-icon" sizes="114x114" href="<?php echo base_url($settings->favicon) ?>">

    <!-- Favicon -->
    <link rel="shortcut icon" href="<?php echo base_url() ?>assets/img/favicon.ico">


    <!-- CSS Libs  -->
    <link rel="stylesheet" href="<?php echo base_url() ?>assets/front/libs/font-awesome/css/fontawesome-all.min.css">
    <link rel="stylesheet" href="<?php echo base_url() ?>assets/front/libs/jarallax/dist/jarallax.css">
    <link rel="stylesheet" href="<?php echo base_url() ?>assets/front/libs/owl-carousel/dist/css/owl.carousel.min.css">
    <link rel="stylesheet" href="<?php echo base_url() ?>assets/front/libs/owl-carousel/dist/css/owl.theme.default.min.css">
    <link rel="stylesheet" href="<?php echo base_url() ?>assets/front/css/simple-line-icons.css">
    <link rel="stylesheet" href="<?php echo base_url() ?>assets/front/fonts/bootstrap/bootstrap-icons.css">
    <link rel="stylesheet" href="<?php echo base_url() ?>assets/admin/css/sweet-alert.css">
    <link rel="stylesheet" href="<?php echo base_url() ?>assets/admin/plugins/line-icons/lineicons.css">
    <link rel="stylesheet" href="<?php echo base_url() ?>assets/front/css/daterangepicker.css" />
    <link rel="stylesheet" href="<?php echo base_url() ?>assets/front/css/owl.carousel.min.css">
    <link rel="stylesheet" href="<?php echo base_url() ?>assets/front/css/owl.theme.default.min.css">
    <link rel="stylesheet" href="<?php echo base_url() ?>assets/front/css/lightbox.css">
    <link rel="stylesheet" href="<?php echo base_url() ?>assets/admin/plugins/datatables-bs4/css/dataTables.bootstrap4.css">

    
    <link rel="stylesheet" href="<?php echo base_url() ?>assets/front/libs/justified-gallery/justifiedGallery.min.css">
    <!-- Template CSS -->
    <link href="<?php echo base_url() ?>assets/front/css/template.min.css?var=<?= settings()->version ?>&time=<?=time();?>" rel="stylesheet">



    <?php if(settings()->enable_animation == 1): ?>
    <link rel="stylesheet" href="<?php echo base_url() ?>assets/front/css/aos.css">
    <?php endif; ?>

    <!-- Select2 -->
    <link rel="stylesheet" href="<?php echo base_url() ?>assets/admin/plugins/select2/css/select2.min.css">
    <!-- nice-select -->
    <link rel="stylesheet" href="<?php echo base_url() ?>assets/admin/css/nice-select.css">
    <!-- date & time picker -->
    <link href="<?php echo base_url() ?>assets/admin/css/bootstrap-datepicker.min.css" rel="stylesheet">
    <link href="<?php echo base_url() ?>assets/admin/css/timepicker.min.css" rel="stylesheet">



    <?php if (isset($page_title) && $page_title == 'Register'): ?>
    <link href="<?php echo base_url() ?>assets/front/css/intelInput.css" rel="stylesheet">
    <?php else: ?>
    <link href="<?php echo base_url() ?>assets/front/css/intlInputPhone.css" rel="stylesheet">
    <?php endif ?>

    <?php if (text_dir() == 'rtl'): ?>
    <link rel="stylesheet" href="<?php echo base_url() ?>assets/admin/css/custom-rtl.css">
    <link rel="stylesheet" href="<?php echo base_url()?>assets/admin/css/bootstrap-rtl.min.css" crossorigin="anonymous">
    <?php endif ?>

    <!-- overwrite css -->

    <?php if($page == 'Company'): ?>
    <?php $font = get_by_id($company->font,'fonts')->name; ?>
    <?php $rgb = hex2rgb($company->color) ?>
    <link href="https://fonts.googleapis.com/css?family=<?php echo str_replace(' ', '+', $font); ?>:400,500,600,700" rel="stylesheet">
    <link href="<?php echo base_url() ?>assets/front/css/style-company-over.php?color=<?php echo html_escape($company->color); ?>&font=<?php echo str_replace(' ', '+', $font).'&rgb='.$rgb ?>" rel="stylesheet">
    <?php else: ?>
    <?php $rgb = hex2rgb(settings()->site_color) ?>
    <link href="<?php echo base_url() ?>assets/front/css/style-over.php?color=<?php echo settings()->site_color; ?>&rgb=<?php echo $rgb ?>" rel="stylesheet">
    <?php endif; ?>
    <link rel="stylesheet" href="<?php echo base_url() ?>assets/front/libs/owl-carousel/dist/css/owl.carousel.min.css">
    <link rel="stylesheet" href="<?php echo base_url() ?>assets/front/libs/owl-carousel/dist/css/owl.theme.default.min.css">

    <?php if (isset($company) && $company->template_style == 2): ?>
    <link href="<?php echo base_url() ?>assets/front/css/style2.css" rel="stylesheet">
    <?php endif ?>

    <!-- csrf token -->
    <script type="text/javascript">
    var csrf_token = '<?= $this->security->get_csrf_hash(); ?>';
    var token_name = '<?= $this->security->get_csrf_token_name();?>';
    </script>


    <?php if (!empty($settings->google_analytics)): ?>
    <?php echo base64_decode($settings->google_analytics) ?>
    <?php endif ?>

    <?php if (settings()->enable_captcha == 1 && settings()->captcha_site_key != ''): ?>
    <script src='https://www.google.com/recaptcha/api.js'></script>
    <?php endif; ?>

   <style type="text/css">
    
    /* SERVICES DROPDOWN – TWO COLUMNS, WIDER, CENTERED */
.navbar-nav .dropdown-menu {
    overflow: visible !important;  /* Remove scrollbar completely */
    white-space: normal;
    min-width: 500px;
    max-width: 600px;
    padding: 20px;
    columns: 2;
    column-gap: 20px;
    left: 50%;
    transform: translateX(-50%);
    max-height: none !important;   /* Ensure no height restrictions */
}

/* Make sure each item can wrap nicely */
.navbar-nav .dropdown-menu .dropdown-item {
    white-space: normal;
    line-height: 1.4;
    padding: 8px 12px;
    break-inside: avoid;
    display: block;
    width: 100%;
    color: #333;
    transition: all 0.2s ease;
}

.navbar-nav .dropdown-menu .dropdown-item:hover {
    background-color: #f0f8f0;
    padding-left: 16px;
}

/* Style "All Services" differently - green and positioned at bottom */
.navbar-nav .dropdown-menu .dropdown-item.all-services {
    color: #34a906 !important;
    font-weight: 600;
    background-color: #f0f8f0;
    border: 2px solid #34a906;
    border-radius: 6px;
    text-align: center;
    margin-top: 15px;
    padding: 10px 16px;
    column-span: all;
}

.navbar-nav .dropdown-menu .dropdown-item.all-services:hover {
    background-color: #34a906;
    color: white !important;
}

/* Fix active menu underline - positioned below text */
.navbar-nav .nav-link.active {
    position: relative;
    text-decoration: none !important;
}

.navbar-nav .nav-link.active::after {
    content: "";
    position: absolute;
    left: 50%;
    transform: translateX(-50%);
    bottom: 0px;                 /* Position at bottom of link */
    width: 60%;
    height: 2px;
    background: #075818;
    border-radius: 2px;
}

.navbar-nav .nav-link {
    padding-left: 12px;
    padding-right: 12px;
    text-decoration: none !important;
}

/* Prevent strikethrough effect on dropdown toggle */
.navbar-nav .dropdown-toggle::after {
    vertical-align: middle !important;
    margin-left: 0.3em;
    border: none !important;
}

/* Fix the horizontal line issue on mobile when dropdown is open */
.navbar-nav .nav-item.dropdown.show .nav-link.dropdown-toggle {
    text-decoration: none !important;
    border-top: none !important;
}

.navbar-nav .nav-link.dropdown-toggle {
    text-decoration: none !important;
    border-top: none !important;
}

/* Mobile adjustments */
@media (max-width: 991px) {
    .navbar-nav .dropdown-menu {
        columns: 1;
        min-width: 100%;
        left: 0;
        transform: none;
        overflow: visible !important;
        max-height: none !important;
    }
    
    /* Ensure no strikethrough on mobile */
    .navbar-nav .nav-link {
        text-decoration: none !important;
        border: none !important;
    }
    
    /* Specifically fix dropdown toggle on mobile */
    .navbar-nav .nav-link.dropdown-toggle {
        border-top: none !important;
        text-decoration: none !important;
    }
    
    .navbar-nav .nav-item.dropdown.show .nav-link {
        border-top: none !important;
    }
}

        /* Small devices (phones, 0px–576px) */
        @media (max-width: 576px) {
            .container, form {
                width: 100%;
                overflow: hidden!important;
            }
        }
        
        /* Medium devices (tablets, 577px–768px) */
        @media (max-width: 768px) {
            .container, form {
                width: 100%;
                overflow: hidden!important;
            }
        }
        <?php echo json_decode(settings()->custom_css) ?>
    </style>


    <?php if (settings()->enable_pwa == 1): ?>
        <?php include 'pwa_config.php'; ?>
    <?php endif ?>

    <?php if (site_mode() == 'dark'): ?>
        <link rel="stylesheet" href="<?php echo base_url() ?>assets/front/css/dark.css">
    <?php endif ?>

</head>

<body<?php if(isset($is_embed) && $is_embed == true){echo ' class="is-embed-no-bg"';} ?> class="<?php if(site_mode() == 'dark'){echo "dark-mode";} ?>">
<!-- main wrapper -->
<div class="main-wrapper">

<!-- header -->
<?php if (isset($menu) && $menu == TRUE): ?>
<header id="navbar">
    <div class="container">
        <nav class="navbar navbar-expand-lg navbar-light bg-whites py-3">
            <a class="navbar-brand" href="<?php echo base_url() ?>">
                <?php if (site_mode() == 'dark'): ?>
                    <?php if (empty(settings()->logo_light)): ?>
                        <?php $logo_url = '/uploads/cropped-aversa-outdoor-logo.webp' ?>
                    <?php else: ?>
                        <?php $logo_url = '/uploads/cropped-aversa-outdoor-logo.webp' ?>
                    <?php endif ?>
                <?php else: ?>
                    <?php $logo_url = '/uploads/cropped-aversa-outdoor-logo.webp' ?>
                <?php endif ?>
                <img width="170px" src="<?php echo $logo_url ?>" alt="logo">
            </a>

            <button type="button" data-toggle="collapse" data-target="#navbarContent" aria-controls="navbarContent" aria-expanded="false" aria-label="Toggle navigation" class="navbar-toggler">
                <span class="navbar-toggler-icon"><i class="fas fa-bars"></i></span>
            </button>

            <!-- Menu -->
            <div id="navbarContent" class="collapse navbar-collapse">

                <ul class="navbar-nav align-items-lg-center ml-auto">

                    <li class="nav-item xs-mb-10 cmenu"><a href="<?php echo base_url() ?>" class="nav-link  <?php if(isset($page_title) && $page_title == "Home"){echo "active";} ?>"><?php echo trans('home') ?></a></li>
                     
<li class="nav-item dropdown cmenu">
    <a href="javascript:void(0);" data-toggle="dropdown" class="nav-link dropdown-toggle 
        <?php if(isset($page_title) && $page_title == "Services"){echo "active";} ?>">
        Services
    </a>

    <ul class="dropdown-menu shadow mt-1">
 

        <li><a class="dropdown-item" href="<?php echo base_url('services/artificial-turf-installation'); ?>">
    Artificial Turf Installation
</a></li>

<li><a class="dropdown-item" href="<?php echo base_url('services/concrete-masonry'); ?>">
    Concrete Masonry
</a></li>

<li><a class="dropdown-item" href="<?php echo base_url('services/driveway-landscaping'); ?>">
    Driveway Landscaping
</a></li>

<li><a class="dropdown-item" href="<?php echo base_url('services/driveway-walkway-paving'); ?>">
    Driveway & Walkway Paving
</a></li>

<li><a class="dropdown-item" href="<?php echo base_url('services/outdoor-planting'); ?>">
    Outdoor Planting
</a></li>

<li><a class="dropdown-item" href="<?php echo base_url('services/landscape-design'); ?>">
    Landscape Design
</a></li>

<li><a class="dropdown-item" href="<?php echo base_url('services/retaining-walls'); ?>">
    Retaining Walls
</a></li>

<li><a class="dropdown-item" href="<?php echo base_url('services/concrete-work'); ?>">
    Concrete Work
</a></li>

<li><a class="dropdown-item" href="<?php echo base_url('services/patio-building'); ?>">
    Patio Building
</a></li>

<li><a class="dropdown-item" href="<?php echo base_url('services/drainage-grading'); ?>">
    Drainage & Grading
</a></li>

<li><a class="dropdown-item" href="<?php echo base_url('services/driveway-construction'); ?>">
    Driveway Construction
</a></li>

<li><a class="dropdown-item" href="<?php echo base_url('services/land-clearing'); ?>">
    Land Clearing
</a></li>

<li><a class="dropdown-item" href="<?php echo base_url('services/tree-removal'); ?>">
    Tree Removal
</a></li>

<li><a class="dropdown-item" href="<?php echo base_url('services/excavation'); ?>">
    Excavation
</a></li>

<li><a class="dropdown-item" href="<?php echo base_url('services/new-construction-landscaping'); ?>">
    New Construction Landscaping
</a></li>

<li><a class="dropdown-item" href="<?php echo base_url('services/outdoor-fireplaces'); ?>">
    Outdoor Fireplaces
</a></li>

<li><a class="dropdown-item" href="<?php echo base_url('services/stone-retaining-walls'); ?>">
    Stone Retaining Walls
</a></li>

<li><a class="dropdown-item" href="<?php echo base_url('services/walls-and-steps'); ?>">
    Walls & Steps
    </a></li>

        <li><a class="dropdown-item all-services" href="<?php echo base_url('services'); ?>">
            View All Services →
</a></li>

    </ul>
</li>


                    <?php if (settings()->enable_blog == 1): ?>
                    <li class="nav-item xs-mb-10 cmenu"><a href="<?php echo base_url('blogs') ?>" class="nav-link <?php if(isset($page_title) && $page_title == "Blogs"){echo "active";} ?>"><?php echo trans('blogs') ?></a></li>
                    <?php endif ?>


                    <?php if (settings()->enable_faq == 1): ?>
                    <li class="nav-item xs-mb-10 cmenu"><a href="<?php echo base_url('faqs') ?>" class="nav-link <?php if(isset($page_title) && $page_title == "Faqs"){echo "active";} ?>"><?php echo trans('faqs') ?></a></li>
                    <?php endif ?>

                    <li class="nav-item xs-mb-10 cmenu"><a href="<?php echo base_url('contact') ?>" class="nav-link <?php if(isset($page_title) && $page_title == "Contact"){echo "active";} ?>"><?php echo trans('contact') ?></a></li>

               
 

                </ul>

                <ul class="navbar-nav align-items-lg-center ml-lg-auto mt-0">
                    <li class="nav-item mr-0">

                        <?php 
                            $logoutbtn_class = "btn btn-sm btn-light-primary ml-auto";
                            $dashbtn_class = "btn btn-sm btn-primary ml-auto";
                        ?>

                       
                            <a class="btn btn-sm btn-light ml-auto" href="tel:(941)-274-1505">Call Now</a>
                                <a class="<?php echo $dashbtn_class ?> open-quote" style="background-color:rgb(52, 169, 6);" href="#">FREE Quote</a>
                    </li>
                </ul>

            </div>
            <!-- End Menu -->

        </nav>
    </div>
</header>
<?php endif ?>


<?php if (isset($page) && $page == 'Company'): ?>
<header class="borderb-1 <?php if(isset($is_embed) && $is_embed == true){echo 'd-hide';} ?> <?php if (isset($page_title) && $page_title == 'Company Home'){echo 'position-absolute';} ?> left-0 top-0 w-100 <?php if (!empty($template) && $template == 5){echo "bg-white";} ?>">

<?php if (isset($company->template_style) && $company->template_style == 5): ?>
    <div class="header-top_area bg-dark py-1">
        <div class="container">
            <div class="row">
                <div class="col-xl-6 col-md-6">
                    <ul class="list-unstyled social-icon p-0 m-0">
                        <?php if(!empty($company->facebook)): ?>
                            <li><a href="<?php echo prep_url($company->facebook) ?>"><i class="text-white fs-14 fab fa-facebook-f"></i></a></li>
                        <?php endif ?>

                        <?php if(!empty($company->twitter)): ?>
                            <li><a href="<?php echo prep_url($company->twitter) ?>"><i class="text-white fs-14 fab fa-twitter"></i></a></li>
                        <?php endif ?>

                        <?php if(!empty($company->instagram)): ?>
                            <li><a href="<?php echo prep_url($company->instagram) ?>"><i class="text-white fs-14 fab fa-instagram"></i></a></li>
                        <?php endif ?>

                        <?php if(!empty($company->whatsapp)): ?>
                            <li><a href="<?php echo prep_url($company->whatsapp) ?>"><i class="text-white fs-14 fab fa-whatsapp"></i></a></li>
                        <?php endif ?>
                    </ul>
                </div>
                <div class="col-xl-6 col-md-6 text-md-right">
                    <div class="pt-0">
                        <?php if(!empty($company->email)): ?>
                            <span class="mr-3 text-muted"><a class="text-white fs-12" href="#"> <i class="bi bi-envelope icon mr-1"></i> <?php echo html_escape($company->email) ?></a></span>
                        <?php endif; ?>

                        <?php if(!empty($company->phone)): ?>
                            <span class="text-muted"><a class="text-white fs-12" href="#"> <i class="bi bi-telephone icon"></i> <?php echo html_escape($company->phone) ?></a></span>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php endif; ?>

<?php if (!empty($template) && $template == 5): ?>
    <?php 
        $text_color = 'text-dark';
        $navbg = 'bg-white';
        $py = '1';
    ?>
<?php else: ?>
    <?php 
        $text_color = '';
        $navbg = '';
        $py = '3';
    ?>
<?php endif ?>

<div class="container">
    <nav class="navbar navbar-expand-lg <?php echo $navbg ?> navbar-light py-<?php echo $py ?> <?php if (isset($company->template_style) && $company->template_style == 2){echo "hide";}?>">
        <a class="navbar-brand mr-lg-5" href="<?php if (isset($is_cdomain) && $is_cdomain == true){echo base_url();}else{echo base_url($slug);} ?>">
            <?php if (!empty($company->logo)):?>
                <img width="<?php echo html_escape($company->size) ?>" src="<?php echo base_url($company->logo) ?>" alt="logo">
            <?php else: ?>
                <span class="text-white company-name"><?php echo html_escape($company->name) ?></span>
            <?php endif; ?>
        </a>

        <button type="button" data-toggle="collapse" data-target="#navbarContent" aria-controls="navbarContent" aria-expanded="false" aria-label="Toggle navigation" class="navbar-toggler">
            <span class="navbar-toggler-icon text-<?php if (isset($page_title) && $page_title == 'Company Home'){echo 'white';} ?> <?php echo html_escape($text_color) ?> text-xs-black"><i class="fas fa-bars"></i></span>
        </button>

        <!-- Menu -->
        <div id="navbarContent" class="collapse navbar-collapse company mt-2">
            
            <ul class="navbar-nav align-items-lg-center ml-auto">
                <li class="nav-item"><a href="<?php if (isset($is_cdomain) && $is_cdomain == true){echo base_url();}else{echo base_url($slug);} ?>" class="nav-link text-<?php if (isset($page_title) && $page_title == 'Company Home'){echo 'white';} ?> <?php echo html_escape($text_color) ?> text-xs-white <?php if(isset($page_title) && $page_title == "Home"){echo "active";} ?>"><?php echo trans('home') ?></a></li>
                
                <li class="nav-item"><a href="<?php echo base_url('services/'.$slug) ?>" class="nav-link text-<?php if (isset($page_title) && $page_title == 'Company Home'){echo 'white';} ?> <?php echo html_escape($text_color) ?> text-xs-white <?php if(isset($page_title) && $page_title == "Services"){echo "active";} ?>"><?php echo trans('services') ?></a></li>

                <!-- Event start -->
  
                <?php if (check_user_feature_access($company->user_id, 'events') == TRUE): ?>
                    <?php if ($company->enable_event == TRUE): ?>
                        <li class="nav-item"><a href="<?php echo base_url('events/'.$slug) ?>" class="nav-link text-<?php if (isset($page_title) && $page_title == 'Company Home'){echo 'white';} ?> <?php echo html_escape($text_color) ?> text-xs-white <?php if(isset($page_title) && $page_title == "Event"){echo "active";} ?>"><?php echo trans('events') ?></a></li>
                    <?php endif; ?>
                <?php endif; ?>
                <!-- Event end -->

                <!-- Product start -->
                <?php if (check_user_feature_access($company->user_id, 'products') == TRUE): ?>
                    <?php if ($company->enable_product == TRUE): ?>
                        <li class="nav-item"><a href="<?php echo base_url('products/'.$slug) ?>" class="nav-link text-<?php if (isset($page_title) && $page_title == 'Company Home'){echo 'white';} ?> <?php echo html_escape($text_color) ?> text-xs-white <?php if(isset($page_title) && $page_title == "Product"){echo "active";} ?>"><?php echo trans('products') ?></a></li>
                    <?php endif; ?>
                <?php endif; ?>
                <!-- Product end -->

                <li class="nav-item"><a href="<?php echo base_url('staffs/'.$slug) ?>" class="nav-link text-<?php if (isset($page_title) && $page_title == 'Company Home'){echo 'white';} ?> <?php echo html_escape($text_color) ?> text-xs-white <?php if(isset($page_title) && $page_title == "Staff"){echo "active";} ?>"><?php echo trans('staff') ?></a></li>
     
                <?php if (check_user_feature_access($company->user_id, 'gallery') == TRUE): ?>
                    <?php if ($company->enable_gallery == TRUE): ?>
                        <li class="nav-item"><a href="<?php echo base_url('gallery/'.$slug) ?>" class="nav-link text-<?php if (isset($page_title) && $page_title == 'Company Home'){echo 'white';} ?> <?php echo html_escape($text_color) ?> text-xs-white <?php if(isset($page_title) && $page_title == "Gallery"){echo "active";} ?>"><?php echo trans('gallery') ?></a></li>
                    <?php endif; ?>
                <?php endif; ?>

                <?php if (!empty(get_pages($company->uid))): ?>
                    <li class="nav-item dropdown">
                        <a href="javascript:void(0);" data-toggle="dropdown" class="nav-link dropdown-toggle <?php if (isset($page_title) && $page_title == 'Company Home'){echo 'text-white';} ?> <?php echo html_escape($text_color) ?>"><?php echo trans('pages') ?></a>

                        <ul class="dropdown-menu shadow mt-1">
                            <?php foreach (get_pages($company->uid) as $page): ?>
                                <li><a class="dropdown-item" href="<?php echo base_url('company/page/'.$company->slug.'/'.$page->slug) ?>"><?php echo html_escape($page->title) ?></a></li>
                            <?php endforeach ?>
                        </ul>
                    </li>
                <?php endif ?>

                <?php if (settings()->enable_multilingual == 1): ?>
                    <li class="nav-item dropdown">
                        <a href="javascript:void(0);" data-toggle="dropdown" class="nav-link dropdown-toggle <?php if (isset($page_title) && $page_title == 'Company Home'){echo 'text-white';} ?> <?php echo html_escape($text_color) ?>">
                            
                            <?php echo company_lang_short_form($company->lang); ?>
                                
                        </a>

                        <ul class="dropdown-menu shadow mt-1">
                            <?php foreach (get_language() as $lang): ?>
                                <li><a class="dropdown-item" href="<?php echo base_url('auth/switch_lang/'.$lang->slug) ?>"><?php echo html_escape($lang->name) ?></a></li>
                            <?php endforeach ?>
                        </ul>
                    </li>
                <?php endif ?>

                <?php if (check_user_feature_access($company->user_id, 'products') == TRUE && $company->enable_product == TRUE): ?>
                    
                    <li class="nav-item dropdown">
                        <a href="#" data-toggle="dropdown" class="nav-link  dropdown-toggles cart_link text-<?php if (isset($page_title) && $page_title == 'Company Home'){echo 'white';} ?> <?php echo html_escape($text_color) ?> text-xs-white">
                            <i class="bi bi-cart icons fs-15">
                                <span class="cart-num <?php if($this->cart->total_items() == 0){echo 'd-none';}else{echo 'd-show';};?>">
                                    <?php $this->load->view('include/header_cart_count'); ?>
                                </span>
                            </i> 
                            
                        </a>
                        
                        <div id="cart" class="load_cart_data">              
                          <?php $this->load->view('include/header_cart');?>
                        </div>
                    </li>
                <?php endif; ?>
            </ul>

            <?php if (isset($is_cdomain) && $is_cdomain == true): ?>
                <?php $site_url = settings()->site_url.'/';?>
            <?php else: ?>
                <?php $site_url = base_url();?>
            <?php endif; ?>


            <ul class="navbar-nav align-items-lg-center ml-lg-auto">
                <li class="nav-item mr-0"> 
                         
                        <a class="btn btn-sm btn-secondary ml-auto text-<?php if (isset($page_title) && $page_title == 'Company Home'){echo 'white';} ?> text-xs-white" href="<?php echo prep_url($site_url.'login') ?>"><?php echo trans('sign-in') ?></a>

                         
                            <a class="btn btn-sm btn-primary ml-auto" href="<?php echo prep_url($site_url.'register') ?>"><?php echo trans('get-started') ?></a> 
                </li>
            </ul>

        </div>
        <!-- End Menu -->

    </nav>
</div>
</header>
<?php endif ?>

