<section class="pt-6" style="background:#f6fbf6; padding-bottom:80px;">
    <div class="container">

        <?php if (empty($posts)): ?>
            <div class="row align-items-center justify-content-center">
                <div class="col-lg-10 col-xl-8 text-center">
                    <?php include 'include/not_found_msg.php'; ?>
                </div>
            </div>

        <?php else: ?>

        <!-- SEO-Optimized Blog Header -->
        <div class="row align-items-center justify-content-center mb-6">
            <div class="col-lg-10 col-xl-8 text-center">

                <!-- REAL H1 FOR SEO -->
                <h1 style="font-size:40px; font-weight:800; color:#075818; margin-bottom:18px;">
                    Aversa Outdoor Blog & Landscaping Tips
                </h1>

                <p style="
                    color:#445;
                    font-size:18px;
                    max-width:650px;
                    margin:auto;
                    line-height:1.6;
                ">
                    Explore expert guides on landscaping, outdoor living, turf installation,
                    hardscaping, garden design, and backyard improvement ideas to help upgrade
                    your outdoor space.
                </p>

                <!-- Search Bar -->
                <form class="rounded-pill pl-4 pr-0 bg-white shadow-sm mt-4"
                      action="<?php echo base_url('blogs'); ?>"
                      style="max-width:480px; margin:auto;">
                    <div class="input-group">
                        <input type="text" class="form-control border-0 pl-0 pr-2"
                               name="search"
                               placeholder="Search landscaping, outdoor living, turf & more…">

                        <div class="input-group-append">
                            <button class="btn text-secondary m-0 px-4" type="submit"
                                    style="border-left:1px solid #eee;">
                                <i class="lni lni-search-alt"></i>
                            </button>
                        </div>
                    </div>
                </form>

            </div>
        </div>

        <!-- Blog Posts Grid -->
        <div class="row">
            <?php $b = 1; foreach ($posts as $post): ?>
                <?php include APPPATH.'views/include/blog_post_item.php'; ?>
            <?php $b++; endforeach; ?>
        </div>

        <!-- Pagination -->
        <div class="mt-8 text-center" style="margin-top:60px;">
            <?php echo $this->pagination->create_links(); ?>
        </div>

        <?php endif; ?>

    </div>
</section>
