<!-- HERO SECTION – CONCRETE MASONRY -->
<section style="background:#e9f7e9; padding:90px 0; text-align:center;">
    <div class="container" style="max-width:760px;">
        
        <h1 style="
            font-size:46px;
            font-weight:800;
            color:#075818;
            margin-bottom:20px;
        ">
            Concrete Masonry Services
        </h1>

        <p style="
            font-size:18px;
            color:#223322;
            line-height:1.7;
        ">
            Aversa Outdoor builds strong, beautiful concrete features designed to last for years. 
            From patios and walkways to custom masonry work, we create outdoor spaces that look clean, 
            feel solid, and stand up to everyday use.
        </p>
    </div>
</section>



<!-- SERVICE DETAILS SECTION -->
<section style="padding:70px 0; background:#fff;">
    <div class="container" style="max-width:900px;">

        <h2 style="color:#075818; font-weight:700; text-align:center; margin-bottom:40px;">
            Why Choose Professional Concrete Masonry?
        </h2>

        <p style="font-size:17px; color:#444; line-height:1.7; margin-bottom:30px;">
            Concrete masonry gives your home a clean and durable finish that stays beautiful with 
            very little care. Our team designs and builds concrete features that are long-lasting, 
            level, and tailored to your outdoor layout. It’s perfect for homeowners who want strong 
            outdoor spaces that look great and handle everyday wear.
        </p>

        <div class="row">

            <!-- Benefit 1 -->
            <div class="col-md-4 mb-4">
                <div style="background:#f6fbf6; padding:25px; border-radius:14px; height:100%; text-align:center;
                    border:1px solid rgba(0,0,0,0.06);">
                    <h3 style="color:#075818; font-size:20px; font-weight:700; margin-bottom:10px;">
                        Built for Strength
                    </h3>
                    <p style="color:#555; font-size:15px;">
                        Durable concrete that supports high-traffic areas and daily use.
                    </p>
                </div>
            </div>

            <!-- Benefit 2 -->
            <div class="col-md-4 mb-4">
                <div style="background:#f6fbf6; padding:25px; border-radius:14px; height:100%; text-align:center;
                    border:1px solid rgba(0,0,0,0.06);">
                    <h3 style="color:#075818; font-size:20px; font-weight:700; margin-bottom:10px;">
                        Clean, Modern Look
                    </h3>
                    <p style="color:#555; font-size:15px;">
                        Smooth finishes and sharp lines for a polished outdoor upgrade.
                    </p>
                </div>
            </div>

            <!-- Benefit 3 -->
            <div class="col-md-4 mb-4">
                <div style="background:#f6fbf6; padding:25px; border-radius:14px; height:100%; text-align:center;
                    border:1px solid rgba(0,0,0,0.06);">
                    <h3 style="color:#075818; font-size:20px; font-weight:700; margin-bottom:10px;">
                        Long-Lasting Quality
                    </h3>
                    <p style="color:#555; font-size:15px;">
                        Designed to handle weather, movement, and Florida’s changing conditions.
                    </p>
                </div>
            </div>

        </div>

        <div style="height:20px;"></div>

        <h2 style="
            color:#075818;
            font-weight:700;
            margin-bottom:15px;
            text-align:center;
        ">
            Perfect for Any Outdoor Project
        </h2>

        <div style="display:flex; justify-content:center;">
            <ul style="
                color:#444;
                font-size:17px;
                line-height:1.7;
                list-style:none;
                padding:0;
                margin:0;
                text-align:center;
            ">
                <li>Patios and outdoor seating areas</li>
                <li>Walkways and paths</li>
                <li>Driveway borders and accents</li>
                <li>Steps, landings, and entryways</li>
                <li>Retaining walls and stone features</li>
                <li>Custom hardscaping designs</li>
            </ul>
        </div>

    </div>
</section>



<!-- CTA SECTION -->
<section style="background:#e9f7e9; padding:80px 0;">
    <div class="container text-center" style="max-width:760px;">

        <h2 style="color:#075818; font-weight:700; font-size:36px; margin-bottom:20px;">
            Ready to Upgrade Your Outdoor Space?
        </h2>

        <p style="color:#444; font-size:18px; line-height:1.6; margin-bottom:32px;">
            Our concrete masonry team creates strong, clean, and long-lasting outdoor structures. 
            From patios to walkways, we bring your vision to life with precision and care.
        </p>

        <div class="hero-cta-wrap" style="
            margin-top:25px;
            display:flex;
            gap:10px;
            align-items:center;
            justify-content:center;
            flex-wrap:wrap;
        ">
            <!-- Quote Button -->
            <a class="open-quote"
               style="
                   background:#34a906;
                   color:#fff;
                   padding:16px 40px;
                   border-radius:30px;
                   font-size:18px;
                   font-weight:600;
                   text-decoration:none;
                   transition:0.2s ease;
               "
               onmouseover="this.style.background='#2a9005'"
               onmouseout="this.style.background='#34a906'">
                Get a Free Quote
            </a>

            <!-- Call Button -->
            <a href="tel:9412741505"
               style="
                   background:#ffffff;
                   color:#34a906;
                   border:2px solid #34a906;
                   padding:12px 20px;
                   border-radius:50px;
                   font-weight:600;
                   font-size:16px;
                   text-decoration:none;
                   display:flex;
                   align-items:center;
                   gap:7px;
               ">
                <i class="bi bi-telephone-fill"></i> Call Now
            </a>
        </div>

    </div>


    <!-- GOOGLE MAPS -->
    <div class="container" style="margin-top:50px;">
        <div class="row">
            <div class="col-12">

                <h3 style="color:#075818; font-weight:700; font-size:26px; text-align:center; margin-bottom:20px;">
                    Visit or Contact Us
                </h3>

                <div style="
                    width:100%;
                    height:420px;
                    border-radius:16px;
                    overflow:hidden;
                    box-shadow:0 12px 32px rgba(0,0,0,0.15);
                ">
                    <iframe 
                        src="https://www.google.com/maps/embed?pb=!1m18!1m12!1m3!1d3539.1410893165043!2d-82.53450392454009!3d27.495987276304366!2m3!1f0!2f0!3f0!3m2!1i1024!2i768!4f13.1!3m3!1m2!1s0x88c317ab6e4454e9%3A0xcf58aaff67a401b4!2sAversa%20Outdoor!5e0!3m2!1sen!2sus!4v1765411553324!5m2!1sen!2sus"
                        width="100%"
                        height="100%"
                        style="border:0;"
                        allowfullscreen=""
                        loading="lazy">
                    </iframe>
                </div>

            </div>
        </div>
    </div>
</section>



<!-- CONCRETE MASONRY – FAQ SECTION -->
<section style="padding:80px 0; background:#f6fbf6;">
    <div class="container">

        <!-- H2 – SEO Optimized Heading -->
        <div class="text-center mx-md-auto mb-5 mb-md-7" style="max-width:760px;">
            <h2 style="color:#075818; font-weight:700;">
                Concrete Masonry FAQs
            </h2>
            <p style="color:#555; font-size:18px; margin-top:10px;">
                Helpful answers to the most common concrete masonry questions.
            </p>
        </div>

        <!-- FAQ ACCORDION -->
        <div class="accordion" id="masonryFaqAccordion">

            <!-- FAQ 1 -->
            <div class="card mb-3" style="border:none; border-radius:12px; box-shadow:0 4px 16px rgba(0,0,0,0.06);">
                <div class="card-header" id="masonryFaq1" style="background:#fff; border-radius:12px;">
                    <h3 style="font-size:20px; font-weight:700; margin:0;">
                        <button class="btn btn-link collapsed text-dark"
                            type="button"
                            data-toggle="collapse"
                            data-target="#masonryAnswer1"
                            style="font-size:20px; font-weight:700; text-decoration:none;">
                            How long does concrete masonry last?
                        </button>
                    </h3>
                </div>

                <div id="masonryAnswer1" class="collapse" data-parent="#masonryFaqAccordion">
                    <div class="card-body" style="padding:20px 25px; color:#444; line-height:1.7;">
                        Quality concrete work can last decades with proper installation. We use strong 
                        materials and careful grading to ensure long-term durability.
                    </div>
                </div>
            </div>

            <!-- FAQ 2 -->
            <div class="card mb-3" style="border:none; border-radius:12px; box-shadow:0 4px 16px rgba(0,0,0,0.06);">
                <div class="card-header" id="masonryFaq2" style="background:#fff; border-radius:12px;">
                    <h3 style="font-size:20px; font-weight:700; margin:0;">
                        <button class="btn btn-link collapsed text-dark"
                            type="button"
                            data-toggle="collapse"
                            data-target="#masonryAnswer2"
                            style="font-size:20px; font-weight:700; text-decoration:none;">
                            What outdoor features can be built with concrete?
                        </button>
                    </h3>
                </div>

                <div id="masonryAnswer2" class="collapse" data-parent="#masonryFaqAccordion">
                    <div class="card-body" style="padding:20px 25px; color:#444; line-height:1.7;">
                        Concrete is used for patios, walkways, steps, driveways, seating areas, 
                        retaining walls, and custom hardscape designs.
                    </div>
                </div>
            </div>

            <!-- FAQ 3 -->
            <div class="card mb-3" style="border:none; border-radius:12px; box-shadow:0 4px 16px rgba(0,0,0,0.06);">
                <div class="card-header" id="masonryFaq3" style="background:#fff; border-radius:12px;">
                    <h3 style="font-size:20px; font-weight:700; margin:0;">
                        <button class="btn btn-link collapsed text-dark"
                            type="button"
                            data-toggle="collapse"
                            data-target="#masonryAnswer3"
                            style="font-size:20px; font-weight:700; text-decoration:none;">
                            How long does concrete take to cure?
                        </button>
                    </h3>
                </div>

                <div id="masonryAnswer3" class="collapse" data-parent="#masonryFaqAccordion">
                    <div class="card-body" style="padding:20px 25px; color:#444; line-height:1.7;">
                        Concrete sets in 24–48 hours but reaches full strength in about 28 days. 
                        We guide you on when each area is safe to walk or place items on.
                    </div>
                </div>
            </div>

            <!-- FAQ 4 -->
            <div class="card mb-3" style="border:none; border-radius:12px; box-shadow:0 4px 16px rgba(0,0,0,0.06);">
                <div class="card-header" id="masonryFaq4" style="background:#fff; border-radius:12px;">
                    <h3 style="font-size:20px; font-weight:700; margin:0;">
                        <button class="btn btn-link collapsed text-dark"
                            type="button"
                            data-toggle="collapse"
                            data-target="#masonryAnswer4"
                            style="font-size:20px; font-weight:700; text-decoration:none;">
                            Can concrete crack over time?
                        </button>
                    </h3>
                </div>

                <div id="masonryAnswer4" class="collapse" data-parent="#masonryFaqAccordion">
                    <div class="card-body" style="padding:20px 25px; color:#444; line-height:1.7;">
                        Minor hairline cracks can happen naturally, but proper installation, 
                        grading, and reinforcement reduce cracking and keep the structure strong.
                    </div>
                </div>
            </div>

            <!-- FAQ 5 -->
            <div class="card mb-3" style="border:none; border-radius:12px; box-shadow:0 4px 16px rgba(0,0,0,0.06);">
                <div class="card-header" id="masonryFaq5" style="background:#fff; border-radius:12px;">
                    <h3 style="font-size:20px; font-weight:700; margin:0;">
                        <button class="btn btn-link collapsed text-dark"
                            type="button"
                            data-toggle="collapse"
                            data-target="#masonryAnswer5"
                            style="font-size:20px; font-weight:700; text-decoration:none;">
                            Do you offer custom concrete designs?
                        </button>
                    </h3>
                </div>

                <div id="masonryAnswer5" class="collapse" data-parent="#masonryFaqAccordion">
                    <div class="card-body" style="padding:20px 25px; color:#444; line-height:1.7;">
                        Yes — we create custom shapes, layouts, borders, and hardscape features 
                        based on your space and design goals.
                    </div>
                </div>
            </div>

        </div>

    </div>
</section>
