<!-- HERO SECTION – CONCRETE WORK -->
<section style="background:#e9f7e9; padding:90px 0; text-align:center;">
    <div class="container" style="max-width:760px;">
        
        <h1 style="
            font-size:46px;
            font-weight:800;
            color:#075818;
            margin-bottom:20px;
        ">
            Concrete Work Services
        </h1>

        <p style="
            font-size:18px;
            color:#223322;
            line-height:1.7;
        ">
            Aversa Outdoor provides professional concrete services for patios, slabs, walkways, 
            driveways, and custom outdoor builds. Our concrete work is designed for strength, 
            clean finishes, and long-term durability.
        </p>
    </div>
</section>



<!-- SERVICE DETAILS SECTION -->
<section style="padding:70px 0; background:#fff;">
    <div class="container" style="max-width:900px;">

        <h2 style="color:#075818; font-weight:700; text-align:center; margin-bottom:40px;">
            Why Choose Aversa Outdoor for Concrete Work?
        </h2>

        <p style="font-size:17px; color:#444; line-height:1.7; margin-bottom:30px;">
            Quality concrete starts with proper preparation, a strong foundation, and skilled 
            finishing. We build concrete surfaces that look good, stay strong, and support your 
            outdoor projects for many years. Whether you need a patio, slab, walkway, or custom 
            concrete work, we deliver clean and lasting results.
        </p>

        <div class="row">

            <!-- Benefit 1 -->
            <div class="col-md-4 mb-4">
                <div style="background:#f6fbf6; padding:25px; border-radius:14px; height:100%; text-align:center;
                    border:1px solid rgba(0,0,0,0.06);">
                    <h3 style="color:#075818; font-size:20px; font-weight:700; margin-bottom:10px;">
                        Strong Base
                    </h3>
                    <p style="color:#555; font-size:15px;">
                        We prepare the ground and foundation for long-lasting strength.
                    </p>
                </div>
            </div>

            <!-- Benefit 2 -->
            <div class="col-md-4 mb-4">
                <div style="background:#f6fbf6; padding:25px; border-radius:14px; height:100%; text-align:center;
                    border:1px solid rgba(0,0,0,0.06);">
                    <h3 style="color:#075818; font-size:20px; font-weight:700; margin-bottom:10px;">
                        Clean, Smooth Finish
                    </h3>
                    <p style="color:#555; font-size:15px;">
                        Your concrete will look neat, even, and professionally crafted.
                    </p>
                </div>
            </div>

            <!-- Benefit 3 -->
            <div class="col-md-4 mb-4">
                <div style="background:#f6fbf6; padding:25px; border-radius:14px; height:100%; text-align:center;
                    border:1px solid rgba(0,0,0,0.06);">
                    <h3 style="color:#075818; font-size:20px; font-weight:700; margin-bottom:10px;">
                        Built for Daily Use
                    </h3>
                    <p style="color:#555; font-size:15px;">
                        Durable concrete designed to handle weather, weight, and busy outdoor areas.
                    </p>
                </div>
            </div>

        </div>

        <div style="height:20px;"></div>

        <h2 style="
            color:#075818;
            font-weight:700;
            margin-bottom:15px;
            text-align:center;
        ">
            Concrete Services We Provide
        </h2>

        <div style="display:flex; justify-content:center;">
            <ul style="
                color:#444;
                font-size:17px;
                line-height:1.7;
                list-style:none;
                padding:0;
                margin:0;
                text-align:center;
            ">
                <li>Concrete patios</li>
                <li>Concrete slabs</li>
                <li>Walkways and pathways</li>
                <li>Driveway repairs or expansions</li>
                <li>Concrete pads for equipment</li>
                <li>Custom concrete designs</li>
            </ul>
        </div>

    </div>
</section>



<!-- CTA SECTION -->
<section style="background:#e9f7e9; padding:80px 0;">
    <div class="container text-center" style="max-width:760px;">

        <h2 style="color:#075818; font-weight:700; font-size:36px; margin-bottom:20px;">
            Need Professional Concrete Work?
        </h2>

        <p style="color:#444; font-size:18px; line-height:1.6; margin-bottom:32px;">
            Get smooth, strong, high-quality concrete built by experienced professionals. 
            We handle everything from preparation to finishing with precision and care.
        </p>

        <div class="hero-cta-wrap" style="
            margin-top:25px;
            display:flex;
            gap:10px;
            align-items:center;
            justify-content:center;
            flex-wrap:wrap;
        ">
            <!-- Quote Button -->
            <a class="open-quote"
               style="
                   background:#34a906;
                   color:#fff;
                   padding:16px 40px;
                   border-radius:30px;
                   font-size:18px;
                   font-weight:600;
                   text-decoration:none;
                   transition:0.2s ease;
               "
               onmouseover="this.style.background='#2a9005'"
               onmouseout="this.style.background='#34a900'">
                Get a Free Quote
            </a>

            <!-- Call Button -->
            <a href="tel:9412741505"
               style="
                   background:#ffffff;
                   color:#34a906;
                   border:2px solid #34a906;
                   padding:12px 20px;
                   border-radius:50px;
                   font-weight:600;
                   font-size:16px;
                   text-decoration:none;
                   display:flex;
                   align-items:center;
                   gap:7px;
               ">
                <i class="bi bi-telephone-fill"></i> Call Now
            </a>
        </div>

    </div>


    <!-- GOOGLE MAPS -->
    <div class="container" style="margin-top:50px;">
        <div class="row">
            <div class="col-12">

                <h3 style="color:#075818; font-weight:700; font-size:26px; text-align:center; margin-bottom:20px;">
                    Visit or Contact Us
                </h3>

                <div style="
                    width:100%;
                    height:420px;
                    border-radius:16px;
                    overflow:hidden;
                    box-shadow:0 12px 32px rgba(0,0,0,0.15);
                ">
                    <iframe 
                        src="https://www.google.com/maps/embed?pb=!1m18!1m12!1m3!1d3539.1410893165043!2d-82.53450392454009!3d27.495987276304366!2m3!1f0!2f0!3f0!3m2!1i1024!2i768!4f13.1!3m3!1m2!1s0x88c317ab6e4454e9%3A0xcf58aaff67a401b4!2sAversa%20Outdoor!5e0!3m2!1sen!2sus!4v1765411553324!5m2!1sen!2sus"
                        width="100%"
                        height="100%"
                        style="border:0;"
                        allowfullscreen=""
                        loading="lazy">
                    </iframe>
                </div>

            </div>
        </div>
    </div>
</section>



<!-- CONCRETE WORK – FAQ SECTION -->
<section style="padding:80px 0; background:#f6fbf6;">
    <div class="container">

        <!-- H2 – SEO Optimized Heading -->
        <div class="text-center mx-md-auto mb-5 mb-md-7" style="max-width:760px;">
            <h2 style="color:#075818; font-weight:700;">
                Concrete Work FAQs
            </h2>
            <p style="color:#555; font-size:18px; margin-top:10px;">
                Common questions about our concrete services.
            </p>
        </div>

        <div class="accordion" id="concreteFaqAccordion">

            <!-- FAQ 1 -->
            <div class="card mb-3" style="border:none; border-radius:12px; box-shadow:0 4px 16px rgba(0,0,0,0.06);">
                <div class="card-header" id="concreteFaq1" style="background:#fff; border-radius:12px;">
                    <h3 style="font-size:20px; font-weight:700; margin:0;">
                        <button class="btn btn-link collapsed text-dark"
                            type="button"
                            data-toggle="collapse"
                            data-target="#concreteAnswer1"
                            style="font-size:20px; font-weight:700; text-decoration:none;">
                            How long does concrete take to cure?
                        </button>
                    </h3>
                </div>

                <div id="concreteAnswer1" class="collapse" data-parent="#concreteFaqAccordion">
                    <div class="card-body" style="padding:20px 25px; color:#444; line-height:1.7;">
                        Concrete begins to harden within hours, but full strength develops over 
                        several days. Most surfaces can be used within a short time depending 
                        on weather and project type.
                    </div>
                </div>
            </div>

            <!-- FAQ 2 -->
            <div class="card mb-3" style="border:none; border-radius:12px; box-shadow:0 4px 16px rgba(0,0,0,0.06);">
                <div class="card-header" id="concreteFaq2" style="background:#fff; border-radius:12px;">
                    <h3 style="font-size:20px; font-weight:700; margin:0;">
                        <button class="btn btn-link collapsed text-dark"
                            type="button"
                            data-toggle="collapse"
                            data-target="#concreteAnswer2"
                            style="font-size:20px; font-weight:700; text-decoration:none;">
                            What can concrete be used for outside?
                        </button>
                    </h3>
                </div>

                <div id="concreteAnswer2" class="collapse" data-parent="#concreteFaqAccordion">
                    <div class="card-body" style="padding:20px 25px; color:#444; line-height:1.7;">
                        Concrete is great for patios, slabs, walkways, driveways, steps, pads, 
                        and many custom outdoor projects. It's durable and low-maintenance.
                    </div>
                </div>
            </div>

            <!-- FAQ 3 -->
            <div class="card mb-3" style="border:none; border-radius:12px; box-shadow:0 4px 16px rgba(0,0,0,0.06);">
                <div class="card-header" id="concreteFaq3" style="background:#fff; border-radius:12px;">
                    <h3 style="font-size:20px; font-weight:700; margin:0;">
                        <button class="btn btn-link collapsed text-dark"
                            type="button"
                            data-toggle="collapse"
                            data-target="#concreteAnswer3"
                            style="font-size:20px; font-weight:700; text-decoration:none;">
                            Do concrete surfaces crack over time?
                        </button>
                    </h3>
                </div>

                <div id="concreteAnswer3" class="collapse" data-parent="#concreteFaqAccordion">
                    <div class="card-body" style="padding:20px 25px; color:#444; line-height:1.7;">
                        Small cracks can happen with weather changes, but we install expansion 
                        joints and a strong base to help limit cracking and add long-term support.
                    </div>
                </div>
            </div>

        </div>

    </div>
</section>
