<!-- HERO SECTION – DRIVEWAY LANDSCAPING -->
<section style="background:#e9f7e9; padding:90px 0; text-align:center;">
    <div class="container" style="max-width:760px;">
        
        <h1 style="
            font-size:46px;
            font-weight:800;
            color:#075818;
            margin-bottom:20px;
        ">
            Driveway Landscaping Services
        </h1>

        <p style="
            font-size:18px;
            color:#223322;
            line-height:1.7;
        ">
            Aversa Outdoor creates clean, modern driveway designs that boost curb appeal. 
            From borders and plants to stone accents and layout upgrades, we make your 
            driveway look polished and welcoming.
        </p>
    </div>
</section>



<!-- SERVICE DETAILS SECTION -->
<section style="padding:70px 0; background:#fff;">
    <div class="container" style="max-width:900px;">

        <h2 style="color:#075818; font-weight:700; text-align:center; margin-bottom:40px;">
            Why Upgrade Your Driveway Landscaping?
        </h2>

        <p style="font-size:17px; color:#444; line-height:1.7; margin-bottom:30px;">
            Driveway landscaping helps your home stand out the moment someone arrives.  
            With clean borders, fresh plants, lighting, and stone details, we turn a plain space 
            into a beautiful entrance that feels well cared for and inviting.
        </p>

        <div class="row">

            <!-- Benefit 1 -->
            <div class="col-md-4 mb-4">
                <div style="background:#f6fbf6; padding:25px; border-radius:14px; height:100%; text-align:center;
                    border:1px solid rgba(0,0,0,0.06);">
                    <h3 style="color:#075818; font-size:20px; font-weight:700; margin-bottom:10px;">
                        Better Curb Appeal
                    </h3>
                    <p style="color:#555; font-size:15px;">
                        Clean lines and new design features make your home stand out.
                    </p>
                </div>
            </div>

            <!-- Benefit 2 -->
            <div class="col-md-4 mb-4">
                <div style="background:#f6fbf6; padding:25px; border-radius:14px; height:100%; text-align:center;
                    border:1px solid rgba(0,0,0,0.06);">
                    <h3 style="color:#075818; font-size:20px; font-weight:700; margin-bottom:10px;">
                        Low Maintenance Options
                    </h3>
                    <p style="color:#555; font-size:15px;">
                        Choose plants and materials that stay neat with little upkeep.
                    </p>
                </div>
            </div>

            <!-- Benefit 3 -->
            <div class="col-md-4 mb-4">
                <div style="background:#f6fbf6; padding:25px; border-radius:14px; height:100%; text-align:center;
                    border:1px solid rgba(0,0,0,0.06);">
                    <h3 style="color:#075818; font-size:20px; font-weight:700; margin-bottom:10px;">
                        Clean Edges & Borders
                    </h3>
                    <p style="color:#555; font-size:15px;">
                        Sharp, smooth borders for a crisp and finished look.
                    </p>
                </div>
            </div>

        </div>

        <div style="height:20px;"></div>

        <h2 style="
            color:#075818;
            font-weight:700;
            margin-bottom:15px;
            text-align:center;
        ">
            Great for Any Style of Home
        </h2>

        <div style="display:flex; justify-content:center;">
            <ul style="
                color:#444;
                font-size:17px;
                line-height:1.7;
                list-style:none;
                padding:0;
                margin:0;
                text-align:center;
            ">
                <li>Driveway borders and edging</li>
                <li>Stone, mulch, or plant accents</li>
                <li>Front yard layout upgrades</li>
                <li>Lighting for walkway or driveway edges</li>
                <li>Low-maintenance landscape designs</li>
                <li>Modern or natural-style driveways</li>
            </ul>
        </div>

    </div>
</section>



<!-- CTA SECTION -->
<section style="background:#e9f7e9; padding:80px 0;">
    <div class="container text-center" style="max-width:760px;">

        <h2 style="color:#075818; font-weight:700; font-size:36px; margin-bottom:20px;">
            Want a Cleaner, Better Looking Driveway?
        </h2>

        <p style="color:#444; font-size:18px; line-height:1.6; margin-bottom:32px;">
            We design and install driveway landscaping that boosts curb appeal and makes 
            your home feel more welcoming the moment you pull in.
        </p>

        <div class="hero-cta-wrap" style="
            margin-top:25px;
            display:flex;
            gap:10px;
            align-items:center;
            justify-content:center;
            flex-wrap:wrap;
        ">
            <!-- Quote Button -->
            <a class="open-quote"
               style="
                   background:#34a906;
                   color:#fff;
                   padding:16px 40px;
                   border-radius:30px;
                   font-size:18px;
                   font-weight:600;
                   text-decoration:none;
                   transition:0.2s ease;
               "
               onmouseover="this.style.background='#2a9005'"
               onmouseout="this.style.background='#34a906'">
                Get a Free Quote
            </a>

            <!-- Call Button -->
            <a href="tel:9412741505"
               style="
                   background:#ffffff;
                   color:#34a906;
                   border:2px solid #34a906;
                   padding:12px 20px;
                   border-radius:50px;
                   font-weight:600;
                   font-size:16px;
                   text-decoration:none;
                   display:flex;
                   align-items:center;
                   gap:7px;
               ">
                <i class="bi bi-telephone-fill"></i> Call Now
            </a>
        </div>

    </div>


    <!-- GOOGLE MAPS -->
    <div class="container" style="margin-top:50px;">
        <div class="row">
            <div class="col-12">

                <h3 style="color:#075818; font-weight:700; font-size:26px; text-align:center; margin-bottom:20px;">
                    Visit or Contact Us
                </h3>

                <div style="
                    width:100%;
                    height:420px;
                    border-radius:16px;
                    overflow:hidden;
                    box-shadow:0 12px 32px rgba(0,0,0,0.15);
                ">
                    <iframe 
                        src="https://www.google.com/maps/embed?pb=!1m18!1m12!1m3!1d3539.1410893165043!2d-82.53450392454009!3d27.495987276304366!2m3!1f0!2f0!3f0!3m2!1i1024!2i768!4f13.1!3m3!1m2!1s0x88c317ab6e4454e9%3A0xcf58aaff67a401b4!2sAversa%20Outdoor!5e0!3m2!1sen!2sus!4v1765411553324!5m2!1sen!2sus"
                        width="100%"
                        height="100%"
                        style="border:0;"
                        allowfullscreen=""
                        loading="lazy">
                    </iframe>
                </div>

            </div>
        </div>
    </div>
</section>



<!-- DRIVEWAY LANDSCAPING – FAQ SECTION -->
<section style="padding:80px 0; background:#f6fbf6;">
    <div class="container">

        <div class="text-center mx-md-auto mb-5 mb-md-7" style="max-width:760px;">
            <h2 style="color:#075818; font-weight:700;">
                Driveway Landscaping FAQs
            </h2>
            <p style="color:#555; font-size:18px; margin-top:10px;">
                Quick answers to the most common questions about driveway landscaping.
            </p>
        </div>

        <div class="accordion" id="drivewayFaqAccordion">

            <!-- FAQ 1 -->
            <div class="card mb-3" style="border:none; border-radius:12px; box-shadow:0 4px 16px rgba(0,0,0,0.06);">
                <div class="card-header" id="drivewayFaq1" style="background:#fff; border-radius:12px;">
                    <h3 style="font-size:20px; font-weight:700; margin:0;">
                        <button class="btn btn-link collapsed text-dark"
                            type="button"
                            data-toggle="collapse"
                            data-target="#drivewayAnswer1"
                            style="font-size:20px; font-weight:700; text-decoration:none;">
                            What is driveway landscaping?
                        </button>
                    </h3>
                </div>

                <div id="drivewayAnswer1" class="collapse" data-parent="#drivewayFaqAccordion">
                    <div class="card-body" style="padding:20px 25px; color:#444; line-height:1.7;">
                        Driveway landscaping adds plants, borders, stones, or design features 
                        to make your driveway look cleaner and more attractive.
                    </div>
                </div>
            </div>

            <!-- FAQ 2 -->
            <div class="card mb-3" style="border:none; border-radius:12px; box-shadow:0 4px 16px rgba(0,0,0,0.06);">
                <div class="card-header" id="drivewayFaq2" style="background:#fff; border-radius:12px;">
                    <h3 style="font-size:20px; font-weight:700; margin:0;">
                        <button class="btn btn-link collapsed text-dark"
                            type="button"
                            data-toggle="collapse"
                            data-target="#drivewayAnswer2"
                            style="font-size:20px; font-weight:700; text-decoration:none;">
                            How can driveway landscaping improve curb appeal?
                        </button>
                    </h3>
                </div>

                <div id="drivewayAnswer2" class="collapse" data-parent="#drivewayFaqAccordion">
                    <div class="card-body" style="padding:20px 25px; color:#444; line-height:1.7;">
                        Clean edges, matching plants, and stone details make the front of your 
                        home feel more finished and welcoming.
                    </div>
                </div>
            </div>

            <!-- FAQ 3 -->
            <div class="card mb-3" style="border:none; border-radius:12px; box-shadow:0 4px 16px rgba(0,0,0,0.06);">
                <div class="card-header" id="drivewayFaq3" style="background:#fff; border-radius:12px;">
                    <h3 style="font-size:20px; font-weight:700; margin:0;">
                        <button class="btn btn-link collapsed text-dark"
                            type="button"
                            data-toggle="collapse"
                            data-target="#drivewayAnswer3"
                            style="font-size:20px; font-weight:700; text-decoration:none;">
                            What materials can be used for driveway borders?
                        </button>
                    </h3>
                </div>

                <div id="drivewayAnswer3" class="collapse" data-parent="#drivewayFaqAccordion">
                    <div class="card-body" style="padding:20px 25px; color:#444; line-height:1.7;">
                        We use stone, concrete, pavers, mulch, metal edging, and low plants to 
                        create clean, attractive borders.
                    </div>
                </div>
            </div>

            <!-- FAQ 4 -->
            <div class="card mb-3" style="border:none; border-radius:12px; box-shadow:0 4px 16px rgba(0,0,0,0.06);">
                <div class="card-header" id="drivewayFaq4" style="background:#fff; border-radius:12px;">
                    <h3 style="font-size:20px; font-weight:700; margin:0;">
                        <button class="btn btn-link collapsed text-dark"
                            type="button"
                            data-toggle="collapse"
                            data-target="#drivewayAnswer4"
                            style="font-size:20px; font-weight:700; text-decoration:none;">
                            Is driveway landscaping expensive?
                        </button>
                    </h3>
                </div>

                <div id="drivewayAnswer4" class="collapse" data-parent="#drivewayFaqAccordion">
                    <div class="card-body" style="padding:20px 25px; color:#444; line-height:1.7;">
                        It depends on the design and materials. Small upgrades are very affordable, 
                        while larger designs offer long-lasting home value.
                    </div>
                </div>
            </div>

            <!-- FAQ 5 -->
            <div class="card mb-3" style="border:none; border-radius:12px; box-shadow:0 4px 16px rgba(0,0,0,0.06);">
                <div class="card-header" id="drivewayFaq5" style="background:#fff; border-radius:12px;">
                    <h3 style="font-size:20px; font-weight:700; margin:0;">
                        <button class="btn btn-link collapsed text-dark"
                            type="button"
                            data-toggle="collapse"
                            data-target="#drivewayAnswer5"
                            style="font-size:20px; font-weight:700; text-decoration:none;">
                            What plants work best beside a driveway?
                        </button>
                    </h3>
                </div>

                <div id="drivewayAnswer5" class="collapse" data-parent="#drivewayFaqAccordion">
                    <div class="card-body" style="padding:20px 25px; color:#444; line-height:1.7;">
                        Low plants that stay neat, handle heat, and don’t overgrow—such as 
                        shrubs, grasses, and drought-friendly options.
                    </div>
                </div>
            </div>

        </div>

    </div>
</section>
