<!-- HERO SECTION – LAND CLEARING -->
<section style="background:#e9f7e9; padding:90px 0; text-align:center;">
    <div class="container" style="max-width:760px;">
        
        <h1 style="
            font-size:46px;
            font-weight:800;
            color:#075818;
            margin-bottom:20px;
        ">
            Land Clearing Services
        </h1>

        <p style="
            font-size:18px;
            color:#223322;
            line-height:1.7;
        ">
            Aversa Outdoor provides fast, safe, and efficient land clearing for new builds, 
            outdoor projects, expansions, and clean property preparation. We clear unwanted 
            brush, debris, and vegetation so your project can start with a clean foundation.
        </p>
    </div>
</section>



<!-- SERVICE DETAILS SECTION -->
<section style="padding:70px 0; background:#fff;">
    <div class="container" style="max-width:900px;">

        <h2 style="color:#075818; font-weight:700; text-align:center; margin-bottom:40px;">
            Professional Land Clearing for Any Project
        </h2>

        <p style="font-size:17px; color:#444; line-height:1.7; margin-bottom:30px;">
            Whether you're starting a new build, installing landscaping, or expanding your 
            outdoor space, clean land is the first step. Our team removes brush, roots, 
            debris, and unwanted vegetation while shaping the area so your project can 
            move forward smoothly.
        </p>

        <div class="row">

            <!-- Benefit 1 -->
            <div class="col-md-4 mb-4">
                <div style="
                    background:#f6fbf6; padding:25px; border-radius:14px; height:100%;
                    text-align:center; border:1px solid rgba(0,0,0,0.06);
                ">
                    <h3 style="color:#075818; font-size:20px; font-weight:700; margin-bottom:10px;">
                        Safe & Efficient
                    </h3>
                    <p style="color:#555; font-size:15px;">
                        We clear land quickly while protecting surrounding structures and areas.
                    </p>
                </div>
            </div>

            <!-- Benefit 2 -->
            <div class="col-md-4 mb-4">
                <div style="
                    background:#f6fbf6; padding:25px; border-radius:14px; height:100%;
                    text-align:center; border:1px solid rgba(0,0,0,0.06);
                ">
                    <h3 style="color:#075818; font-size:20px; font-weight:700; margin-bottom:10px;">
                        Ready for Building
                    </h3>
                    <p style="color:#555; font-size:15px;">
                        Clean preparation that sets the stage for new homes, additions, or outdoor upgrades.
                    </p>
                </div>
            </div>

            <!-- Benefit 3 -->
            <div class="col-md-4 mb-4">
                <div style="
                    background:#f6fbf6; padding:25px; border-radius:14px; height:100%;
                    text-align:center; border:1px solid rgba(0,0,0,0.06);
                ">
                    <h3 style="color:#075818; font-size:20px; font-weight:700; margin-bottom:10px;">
                        Full Cleanup
                    </h3>
                    <p style="color:#555; font-size:15px;">
                        Brush, debris, and vegetation are removed so your site is clean and ready.
                    </p>
                </div>
            </div>

        </div>

        <div style="height:20px;"></div>

        <h2 style="
            color:#075818;
            font-weight:700;
            margin-bottom:15px;
            text-align:center;
        ">
            What We Clear
        </h2>

        <div style="display:flex; justify-content:center;">
            <ul style="
                color:#444;
                font-size:17px;
                line-height:1.7;
                list-style:none;
                padding:0;
                margin:0;
                text-align:center;
            ">
                <li>Brush and overgrown vegetation</li>
                <li>Small trees and root systems</li>
                <li>Debris, fallen limbs, and unwanted material</li>
                <li>Rocks and surface obstacles</li>
                <li>Old landscaping and unused structures</li>
                <li>Ground preparation for builds or new projects</li>
            </ul>
        </div>

    </div>
</section>



<!-- CTA SECTION -->
<section style="background:#e9f7e9; padding:80px 0;">
    <div class="container text-center" style="max-width:760px;">

        <h2 style="color:#075818; font-weight:700; font-size:36px; margin-bottom:20px;">
            Need Land Cleared for Your Next Project?
        </h2>

        <p style="color:#444; font-size:18px; line-height:1.6; margin-bottom:32px;">
            We clear land safely and efficiently so you can start building or designing 
            without delays. Our team handles everything — from debris removal to site preparation.
        </p>

        <div style="
            margin-top:25px; 
            display:flex; 
            gap:10px; 
            align-items:center; 
            justify-content:center; 
            flex-wrap:wrap;
        ">

            <!-- Quote Button -->
            <a class="open-quote"
               style="
                    background:#34a906;
                    color:#fff;
                    padding:16px 40px;
                    border-radius:30px;
                    font-size:18px;
                    font-weight:600;
                    text-decoration:none;
                    transition:0.2s ease;
               "
               onmouseover="this.style.background='#2a9005'"
               onmouseout="this.style.background='#34a906'">
                Get a Free Quote
            </a>

            <!-- Call Button -->
            <a href="tel:9412741505"
               style="
                    background:#ffffff;
                    color:#34a906;
                    border:2px solid #34a906;
                    padding:12px 20px;
                    border-radius:50px;
                    font-weight:600;
                    font-size:16px;
                    text-decoration:none;
                    display:flex;
                    align-items:center;
                    gap:7px;
               ">
               <i class="bi bi-telephone-fill"></i> Call Now
            </a>

        </div>

    </div>


    <!-- GOOGLE MAPS -->
    <div class="container" style="margin-top:50px;">
        <div class="row">
            <div class="col-12">

                <h3 style="color:#075818; font-weight:700; font-size:26px; text-align:center; margin-bottom:20px;">
                    Visit or Contact Us
                </h3>

                <div style="
                    width:100%;
                    height:420px;
                    border-radius:16px;
                    overflow:hidden;
                    box-shadow:0 12px 32px rgba(0,0,0,0.15);
                ">
                    <iframe 
                        src="https://www.google.com/maps/embed?pb=!1m18!1m12!1m3!1d3539.1410893165043!2d-82.53450392454009!3d27.495987276304366!2m3!1f0!2f0!3f0!3m2!1i1024!2i768!4f13.1!3m3!1m2!1s0x88c317ab6e4454e9%3A0xcf58aaff67a401b4!2sAversa%20Outdoor!5e0!3m2!1sen!2sus!4v1765411553324!5m2!1sen!2sus"
                        width="100%" height="100%" style="border:0;" loading="lazy" allowfullscreen>
                    </iframe>
                </div>

            </div>
        </div>
    </div>
</section>



<!-- LAND CLEARING – FAQ SECTION -->
<section style="padding:80px 0; background:#f6fbf6;">
    <div class="container">

        <div class="text-center mx-md-auto mb-5 mb-md-7" style="max-width:760px;">
            <h2 style="color:#075818; font-weight:700;">
                Land Clearing FAQs
            </h2>
            <p style="color:#555; font-size:18px; margin-top:10px;">
                Common questions about preparing land for new builds and outdoor projects.
            </p>
        </div>

        <div class="accordion" id="landClearingFaqAccordion">

            <!-- FAQ 1 -->
            <div class="card mb-3" style="border:none; border-radius:12px; box-shadow:0 4px 16px rgba(0,0,0,0.06);">
                <div class="card-header" id="lcFaq1" style="background:#fff; border-radius:12px;">
                    <h3 style="font-size:20px; font-weight:700; margin:0;">
                        <button class="btn btn-link collapsed text-dark"
                            type="button" data-toggle="collapse"
                            data-target="#lcAnswer1"
                            style="font-size:20px; font-weight:700; text-decoration:none;">
                            What does land clearing include?
                        </button>
                    </h3>
                </div>

                <div id="lcAnswer1" class="collapse" data-parent="#landClearingFaqAccordion">
                    <div class="card-body" style="padding:20px 25px; color:#444; line-height:1.7;">
                        Land clearing includes removing brush, roots, trees, debris, rocks, old 
                        landscaping, and anything else blocking your project. We also level and 
                        prepare the area for the next step.
                    </div>
                </div>
            </div>

            <!-- FAQ 2 -->
            <div class="card mb-3" style="border:none; border-radius:12px; box-shadow:0 4px 16px rgba(0,0,0,0.06);">
                <div class="card-header" id="lcFaq2" style="background:#fff; border-radius:12px;">
                    <h3 style="font-size:20px; font-weight:700; margin:0;">
                        <button class="btn btn-link collapsed text-dark"
                            type="button" data-toggle="collapse"
                            data-target="#lcAnswer2"
                            style="font-size:20px; font-weight:700; text-decoration:none;">
                            How long does land clearing take?
                        </button>
                    </h3>
                </div>

                <div id="lcAnswer2" class="collapse" data-parent="#landClearingFaqAccordion">
                    <div class="card-body" style="padding:20px 25px; color:#444; line-height:1.7;">
                        Most clearing jobs take one day to a few days depending on property size, 
                        density, and the amount of debris. We give clear timelines during your quote.
                    </div>
                </div>
            </div>

            <!-- FAQ 3 -->
            <div class="card mb-3" style="border:none; border-radius:12px; box-shadow:0 4px 16px rgba(0,0,0,0.06);">
                <div class="card-header" id="lcFaq3" style="background:#fff; border-radius:12px;">
                    <h3 style="font-size:20px; font-weight:700; margin:0;">
                        <button class="btn btn-link collapsed text-dark"
                            type="button" data-toggle="collapse"
                            data-target="#lcAnswer3"
                            style="font-size:20px; font-weight:700; text-decoration:none;">
                            Do you remove all debris from the property?
                        </button>
                    </h3>
                </div>

                <div id="lcAnswer3" class="collapse" data-parent="#landClearingFaqAccordion">
                    <div class="card-body" style="padding:20px 25px; color:#444; line-height:1.7;">
                        Yes — we haul away everything we clear so the site is clean and ready for 
                        construction or landscaping.
                    </div>
                </div>
            </div>

            <!-- FAQ 4 -->
            <div class="card mb-3" style="border:none; border-radius:12px; box-shadow:0 4px 16px rgba(0,0,0,0.06);">
                <div class="card-header" id="lcFaq4" style="background:#fff; border-radius:12px;">
                    <h3 style="font-size:20px; font-weight:700; margin:0;">
                        <button class="btn btn-link collapsed text-dark"
                            type="button" data-toggle="collapse"
                            data-target="#lcAnswer4"
                            style="font-size:20px; font-weight:700; text-decoration:none;">
                            Can you prepare the site for landscaping or new builds?
                        </button>
                    </h3>
                </div>

                <div id="lcAnswer4" class="collapse" data-parent="#landClearingFaqAccordion">
                    <div class="card-body" style="padding:20px 25px; color:#444; line-height:1.7;">
                        Yes — we create a smooth, level, and clean surface so your next step 
                        (landscaping, turf, patios, or construction) can begin right away.
                    </div>
                </div>
            </div>

        </div>

    </div>
</section>
