<!-- HERO SECTION – NEW CONSTRUCTION LANDSCAPING -->
<section style="background:#e9f7e9; padding:90px 0; text-align:center;">
    <div class="container" style="max-width:760px;">
        
        <h1 style="
            font-size:46px;
            font-weight:800;
            color:#075818;
            margin-bottom:20px;
        ">
            New Construction Landscaping Services
        </h1>

        <p style="
            font-size:18px;
            color:#223322;
            line-height:1.7;
        ">
            Aversa Outdoor designs and installs complete landscaping for newly built homes. 
            From grading and planting to hardscaping and clean finishes, we bring your new 
            property to life with fresh, modern outdoor design.
        </p>
    </div>
</section>



<!-- SERVICE DETAILS SECTION -->
<section style="padding:70px 0; background:#fff;">
    <div class="container" style="max-width:900px;">

        <h2 style="color:#075818; font-weight:700; text-align:center; margin-bottom:40px;">
            Complete Landscaping for New Homes
        </h2>

        <p style="font-size:17px; color:#444; line-height:1.7; margin-bottom:30px;">
            Your new home deserves an outdoor space that matches its beauty. We plan, build,
            and install everything from clean planting layouts to walkways, turf, rock beds,
            and custom hardscaping features. Our team creates balanced, functional designs
            that give your home strong curb appeal from day one.
        </p>

        <div class="row">

            <!-- Benefit 1 -->
            <div class="col-md-4 mb-4">
                <div style="
                    background:#f6fbf6; padding:25px; border-radius:14px; height:100%;
                    text-align:center; border:1px solid rgba(0,0,0,0.06);
                ">
                    <h3 style="color:#075818; font-size:20px; font-weight:700; margin-bottom:10px;">
                        Start-to-Finish Design
                    </h3>
                    <p style="color:#555; font-size:15px;">
                        Full layouts for front yards, backyards, and property-wide installs.
                    </p>
                </div>
            </div>

            <!-- Benefit 2 -->
            <div class="col-md-4 mb-4">
                <div style="
                    background:#f6fbf6; padding:25px; border-radius:14px; height:100%;
                    text-align:center; border:1px solid rgba(0,0,0,0.06);
                ">
                    <h3 style="color:#075818; font-size:20px; font-weight:700; margin-bottom:10px;">
                        Clean Installation
                    </h3>
                    <p style="color:#555; font-size:15px;">
                        Fresh plants, borders, rock beds, and lawn upgrades for a finished look.
                    </p>
                </div>
            </div>

            <!-- Benefit 3 -->
            <div class="col-md-4 mb-4">
                <div style="
                    background:#f6fbf6; padding:25px; border-radius:14px; height:100%;
                    text-align:center; border:1px solid rgba(0,0,0,0.06);
                ">
                    <h3 style="color:#075818; font-size:20px; font-weight:700; margin-bottom:10px;">
                        Built for Long-Term Beauty
                    </h3>
                    <p style="color:#555; font-size:15px;">
                        Designs that stay neat, strong, and low maintenance as your home grows.
                    </p>
                </div>
            </div>

        </div>

        <div style="height:20px;"></div>

        <h2 style="
            color:#075818;
            font-weight:700;
            margin-bottom:15px;
            text-align:center;
        ">
            What’s Included in New Construction Landscaping?
        </h2>

        <div style="display:flex; justify-content:center;">
            <ul style="
                color:#444;
                font-size:17px;
                line-height:1.7;
                list-style:none;
                padding:0;
                margin:0;
                text-align:center;
            ">
                <li>Front yard and backyard landscape design</li>
                <li>Fresh planting layouts and clean borders</li>
                <li>Rock, mulch, and low-maintenance features</li>
                <li>Walkways, edging, and small hardscapes</li>
                <li>Drainage-friendly grading and soil prep</li>
                <li>Artificial turf or sod installation</li>
                <li>Modern, minimal, or lush landscape styles</li>
            </ul>
        </div>

    </div>
</section>



<!-- CTA SECTION -->
<section style="background:#e9f7e9; padding:80px 0;">
    <div class="container text-center" style="max-width:760px;">

        <h2 style="color:#075818; font-weight:700; font-size:36px; margin-bottom:20px;">
            Ready to Finish Your New Home’s Landscaping?
        </h2>

        <p style="color:#444; font-size:18px; line-height:1.6; margin-bottom:32px;">
            We design outdoor spaces that make your home feel complete. Get a layout that fits 
            your style and a clean installation that brings it to life.
        </p>

        <div style="
            margin-top:25px; 
            display:flex; 
            gap:10px; 
            align-items:center; 
            justify-content:center; 
            flex-wrap:wrap;
        ">

            <!-- Quote Button -->
            <a class="open-quote"
               style="
                    background:#34a906;
                    color:#fff;
                    padding:16px 40px;
                    border-radius:30px;
                    font-size:18px;
                    font-weight:600;
                    text-decoration:none;
                    transition:0.2s ease;
               "
               onmouseover="this.style.background='#2a9005'"
               onmouseout="this.style.background='#34a906'">
                Get a Free Quote
            </a>

            <!-- Call Button -->
            <a href="tel:9412741505"
               style="
                    background:#ffffff;
                    color:#34a906;
                    border:2px solid #34a906;
                    padding:12px 20px;
                    border-radius:50px;
                    font-weight:600;
                    font-size:16px;
                    text-decoration:none;
                    display:flex;
                    align-items:center;
                    gap:7px;
               ">
               <i class="bi bi-telephone-fill"></i> Call Now
            </a>

        </div>

    </div>


    <!-- GOOGLE MAPS -->
    <div class="container" style="margin-top:50px;">
        <div class="row">
            <div class="col-12">

                <h3 style="color:#075818; font-weight:700; font-size:26px; text-align:center; margin-bottom:20px;">
                    Visit or Contact Us
                </h3>

                <div style="
                    width:100%;
                    height:420px;
                    border-radius:16px;
                    overflow:hidden;
                    box-shadow:0 12px 32px rgba(0,0,0,0.15);
                ">
                    <iframe 
                        src="https://www.google.com/maps/embed?pb=!1m18!1m12!1m3!1d3539.1410893165043!2d-82.53450392454009!3d27.495987276304366!2m3!1f0!2f0!3f0!3m2!1i1024!2i768!4f13.1!3m3!1m2!1s0x88c317ab6e4454e9%3A0xcf58aaff67a401b4!2sAversa%20Outdoor!5e0!3m2!1sen!2sus!4v1765411553324!5m2!1sen!2sus"
                        width="100%" height="100%" style="border:0;" loading="lazy" allowfullscreen>
                    </iframe>
                </div>

            </div>
        </div>
    </div>
</section>



<!-- NEW CONSTRUCTION LANDSCAPING – FAQ SECTION -->
<section style="padding:80px 0; background:#f6fbf6;">
    <div class="container">

        <div class="text-center mx-md-auto mb-5 mb-md-7" style="max-width:760px;">
            <h2 style="color:#075818; font-weight:700;">
                New Construction Landscaping FAQs
            </h2>
            <p style="color:#555; font-size:18px; margin-top:10px;">
                Helpful answers for homeowners finishing a newly built property.
            </p>
        </div>

        <div class="accordion" id="newConstructionFaqAccordion">

            <!-- FAQ 1 -->
            <div class="card mb-3" style="border:none; border-radius:12px; box-shadow:0 4px 16px rgba(0,0,0,0.06);">
                <div class="card-header" id="ncFaq1" style="background:#fff; border-radius:12px;">
                    <h3 style="font-size:20px; font-weight:700; margin:0;">
                        <button class="btn btn-link collapsed text-dark"
                            type="button" data-toggle="collapse"
                            data-target="#ncAnswer1"
                            style="font-size:20px; font-weight:700; text-decoration:none;">
                            When should landscaping be done for a new home?
                        </button>
                    </h3>
                </div>

                <div id="ncAnswer1" class="collapse" data-parent="#newConstructionFaqAccordion">
                    <div class="card-body" style="padding:20px 25px; color:#444; line-height:1.7;">
                        Landscaping is usually installed after construction is finished. 
                        This prevents damage and lets us shape the ground correctly before planting 
                        or installing turf, rock, or hardscapes.
                    </div>
                </div>
            </div>

            <!-- FAQ 2 -->
            <div class="card mb-3" style="border:none; border-radius:12px; box-shadow:0 4px 16px rgba(0,0,0,0.06);">
                <div class="card-header" id="ncFaq2" style="background:#fff; border-radius:12px;">
                    <h3 style="font-size:20px; font-weight:700; margin:0;">
                        <button class="btn btn-link collapsed text-dark"
                            type="button" data-toggle="collapse"
                            data-target="#ncAnswer2"
                            style="font-size:20px; font-weight:700; text-decoration:none;">
                            What’s included in new construction landscaping?
                        </button>
                    </h3>
                </div>

                <div id="ncAnswer2" class="collapse" data-parent="#newConstructionFaqAccordion">
                    <div class="card-body" style="padding:20px 25px; color:#444; line-height:1.7;">
                        We handle designs, planting, rock or mulch installation, turf or sod,
                        grading, edging, walkways, and finishing touches that give your home a 
                        polished, complete look.
                    </div>
                </div>
            </div>

            <!-- FAQ 3 -->
            <div class="card mb-3" style="border:none; border-radius:12px; box-shadow:0 4px 16px rgba(0,0,0,0.06);">
                <div class="card-header" id="ncFaq3" style="background:#fff; border-radius:12px;">
                    <h3 style="font-size:20px; font-weight:700; margin:0;">
                        <button class="btn btn-link collapsed text-dark"
                            type="button" data-toggle="collapse"
                            data-target="#ncAnswer3"
                            style="font-size:20px; font-weight:700; text-decoration:none;">
                            Do you help choose plants and design styles?
                        </button>
                    </h3>
                </div>

                <div id="ncAnswer3" class="collapse" data-parent="#newConstructionFaqAccordion">
                    <div class="card-body" style="padding:20px 25px; color:#444; line-height:1.7;">
                        Yes — we guide you through choosing plants, layout styles, colors, and 
                        features that match your home’s architecture and your personal taste.
                    </div>
                </div>
            </div>

            <!-- FAQ 4 -->
            <div class="card mb-3" style="border:none; border-radius:12px; box-shadow:0 4px 16px rgba(0,0,0,0.06);">
                <div class="card-header" id="ncFaq4" style="background:#fff; border-radius:12px;">
                    <h3 style="font-size:20px; font-weight:700; margin:0;">
                        <button class="btn btn-link collapsed text-dark"
                            type="button" data-toggle="collapse"
                            data-target="#ncAnswer4"
                            style="font-size:20px; font-weight:700; text-decoration:none;">
                            Can you install turf instead of natural grass?
                        </button>
                    </h3>
                </div>

                <div id="ncAnswer4" class="collapse" data-parent="#newConstructionFaqAccordion">
                    <div class="card-body" style="padding:20px 25px; color:#444; line-height:1.7;">
                        Absolutely — artificial turf is great for low-maintenance landscapes. We 
                        install turf that looks clean, stays green, and fits modern home designs.
                    </div>
                </div>
            </div>

        </div>

    </div>
</section>
