<!-- HERO SECTION – OUTDOOR FIREPLACES -->
<section style="background:#e9f7e9; padding:90px 0; text-align:center;">
    <div class="container" style="max-width:760px;">
        
        <h1 style="
            font-size:46px;
            font-weight:800;
            color:#075818;
            margin-bottom:20px;
        ">
            Outdoor Fireplace Installation
        </h1>

        <p style="
            font-size:18px;
            color:#223322;
            line-height:1.7;
        ">
            Aversa Outdoor builds custom outdoor fireplaces that bring warmth, comfort, 
            and style to your backyard. Enjoy a cozy space to relax, entertain, and spend 
            time outdoors all year long.
        </p>
    </div>
</section>



<!-- SERVICE DETAILS SECTION -->
<section style="padding:70px 0; background:#fff;">
    <div class="container" style="max-width:900px;">

        <h2 style="color:#075818; font-weight:700; text-align:center; margin-bottom:40px;">
            Bring Warmth & Style to Your Outdoor Space
        </h2>

        <p style="font-size:17px; color:#444; line-height:1.7; margin-bottom:30px;">
            Our custom outdoor fireplaces are built to match your home’s style and your 
            outdoor living needs. Whether you want a simple, modern design or a large 
            stone feature, we create fireplaces that look beautiful and last for years.
        </p>

        <div class="row">

            <!-- Benefit 1 -->
            <div class="col-md-4 mb-4">
                <div style="
                    background:#f6fbf6; padding:25px; border-radius:14px; height:100%;
                    text-align:center; border:1px solid rgba(0,0,0,0.06);
                ">
                    <h3 style="color:#075818; font-size:20px; font-weight:700; margin-bottom:10px;">
                        Custom Designs
                    </h3>
                    <p style="color:#555; font-size:15px;">
                        Built to fit your space, style, and outdoor living layout.
                    </p>
                </div>
            </div>

            <!-- Benefit 2 -->
            <div class="col-md-4 mb-4">
                <div style="
                    background:#f6fbf6; padding:25px; border-radius:14px; height:100%;
                    text-align:center; border:1px solid rgba(0,0,0,0.06);
                ">
                    <h3 style="color:#075818; font-size:20px; font-weight:700; margin-bottom:10px;">
                        Cozy Gathering Space
                    </h3>
                    <p style="color:#555; font-size:15px;">
                        A warm and inviting place to relax with family or friends.
                    </p>
                </div>
            </div>

            <!-- Benefit 3 -->
            <div class="col-md-4 mb-4">
                <div style="
                    background:#f6fbf6; padding:25px; border-radius:14px; height:100%;
                    text-align:center; border:1px solid rgba(0,0,0,0.06);
                ">
                    <h3 style="color:#075818; font-size:20px; font-weight:700; margin-bottom:10px;">
                        Built to Last
                    </h3>
                    <p style="color:#555; font-size:15px;">
                        Durable materials that hold up to heat, weather, and daily use.
                    </p>
                </div>
            </div>

        </div>

        <div style="height:20px;"></div>

        <h2 style="
            color:#075818;
            font-weight:700;
            margin-bottom:15px;
            text-align:center;
        ">
            Perfect for Any Outdoor Living Area
        </h2>

        <div style="display:flex; justify-content:center;">
            <ul style="
                color:#444;
                font-size:17px;
                line-height:1.7;
                list-style:none;
                padding:0;
                margin:0;
                text-align:center;
            ">
                <li>Patios and lounge spaces</li>
                <li>Poolside entertaining areas</li>
                <li>Outdoor kitchens</li>
                <li>Backyard seating areas</li>
                <li>Covered patios or pergolas</li>
                <li>Modern and rustic landscape designs</li>
            </ul>
        </div>

    </div>
</section>



<!-- CTA SECTION -->
<section style="background:#e9f7e9; padding:80px 0;">
    <div class="container text-center" style="max-width:760px;">

        <h2 style="color:#075818; font-weight:700; font-size:36px; margin-bottom:20px;">
            Ready to Build Your Outdoor Fireplace?
        </h2>

        <p style="color:#444; font-size:18px; line-height:1.6; margin-bottom:32px;">
            Create a warm and relaxing space you can enjoy every season. We design each 
            outdoor fireplace to match your home and bring your backyard to life.
        </p>

        <div style="
            margin-top:25px; 
            display:flex; 
            gap:10px; 
            align-items:center; 
            justify-content:center; 
            flex-wrap:wrap;
        ">

            <!-- Quote Button -->
            <a class="open-quote"
               style="
                    background:#34a906;
                    color:#fff;
                    padding:16px 40px;
                    border-radius:30px;
                    font-size:18px;
                    font-weight:600;
                    text-decoration:none;
                    transition:0.2s ease;
               "
               onmouseover="this.style.background='#2a9005'"
               onmouseout="this.style.background='#34a906'">
                Get a Free Quote
            </a>

            <!-- Call Button -->
            <a href="tel:9412741505"
               style="
                    background:#ffffff;
                    color:#34a906;
                    border:2px solid #34a906;
                    padding:12px 20px;
                    border-radius:50px;
                    font-weight:600;
                    font-size:16px;
                    text-decoration:none;
                    display:flex;
                    align-items:center;
                    gap:7px;
               ">
               <i class="bi bi-telephone-fill"></i> Call Now
            </a>

        </div>

    </div>


    <!-- GOOGLE MAPS -->
    <div class="container" style="margin-top:50px;">
        <div class="row">
            <div class="col-12">

                <h3 style="color:#075818; font-weight:700; font-size:26px; text-align:center; margin-bottom:20px;">
                    Visit or Contact Us
                </h3>

                <div style="
                    width:100%;
                    height:420px;
                    border-radius:16px;
                    overflow:hidden;
                    box-shadow:0 12px 32px rgba(0,0,0,0.15);
                ">
                    <iframe 
                        src="https://www.google.com/maps/embed?pb=!1m18!1m12!1m3!1d3539.1410893165043!2d-82.53450392454009!3d27.495987276304366!2m3!1f0!2f0!3f0!3m2!1i1024!2i768!4f13.1!3m3!1m2!1s0x88c317ab6e4454e9%3A0xcf58aaff67a401b4!2sAversa%20Outdoor!5e0!3m2!1sen!2sus!4v1765411553324!5m2!1sen!2sus"
                        width="100%" height="100%" style="border:0;" loading="lazy" allowfullscreen>
                    </iframe>
                </div>

            </div>
        </div>
    </div>
</section>



<!-- OUTDOOR FIREPLACES – FAQ SECTION -->
<section style="padding:80px 0; background:#f6fbf6;">
    <div class="container">

        <div class="text-center mx-md-auto mb-5 mb-md-7" style="max-width:760px;">
            <h2 style="color:#075818; font-weight:700;">
                Outdoor Fireplace FAQs
            </h2>
            <p style="color:#555; font-size:18px; margin-top:10px;">
                Common questions about building and enjoying outdoor fireplaces.
            </p>
        </div>

        <div class="accordion" id="fireplaceFaqAccordion">

            <!-- FAQ 1 -->
            <div class="card mb-3" style="border:none; border-radius:12px; box-shadow:0 4px 16px rgba(0,0,0,0.06);">
                <div class="card-header" id="fireFaq1" style="background:#fff; border-radius:12px;">
                    <h3 style="font-size:20px; font-weight:700; margin:0;">
                        <button class="btn btn-link collapsed text-dark"
                            type="button" data-toggle="collapse"
                            data-target="#fireAnswer1"
                            style="font-size:20px; font-weight:700; text-decoration:none;">
                            What types of outdoor fireplaces can you build?
                        </button>
                    </h3>
                </div>

                <div id="fireAnswer1" class="collapse" data-parent="#fireplaceFaqAccordion">
                    <div class="card-body" style="padding:20px 25px; color:#444; line-height:1.7;">
                        We build wood-burning, natural gas, propane, and custom stone fireplaces. 
                        Each design is built to match your outdoor style and layout.
                    </div>
                </div>
            </div>

            <!-- FAQ 2 -->
            <div class="card mb-3" style="border:none; border-radius:12px; box-shadow:0 4px 16px rgba(0,0,0,0.06);">
                <div class="card-header" id="fireFaq2" style="background:#fff; border-radius:12px;">
                    <h3 style="font-size:20px; font-weight:700; margin:0;">
                        <button class="btn btn-link collapsed text-dark"
                            type="button" data-toggle="collapse"
                            data-target="#fireAnswer2"
                            style="font-size:20px; font-weight:700; text-decoration:none;">
                            How long does installation take?
                        </button>
                    </h3>
                </div>

                <div id="fireAnswer2" class="collapse" data-parent="#fireplaceFaqAccordion">
                    <div class="card-body" style="padding:20px 25px; color:#444; line-height:1.7;">
                        Most outdoor fireplaces take a few days to build depending on size, design, 
                        and materials. Larger custom builds may take longer.
                    </div>
                </div>
            </div>

            <!-- FAQ 3 -->
            <div class="card mb-3" style="border:none; border-radius:12px; box-shadow:0 4px 16px rgba(0,0,0,0.06);">
                <div class="card-header" id="fireFaq3" style="background:#fff; border-radius:12px;">
                    <h3 style="font-size:20px; font-weight:700; margin:0;">
                        <button class="btn btn-link collapsed text-dark"
                            type="button" data-toggle="collapse"
                            data-target="#fireAnswer3"
                            style="font-size:20px; font-weight:700; text-decoration:none;">
                            Are outdoor fireplaces safe?
                        </button>
                    </h3>
                </div>

                <div id="fireAnswer3" class="collapse" data-parent="#fireplaceFaqAccordion">
                    <div class="card-body" style="padding:20px 25px; color:#444; line-height:1.7;">
                        Yes — we build fireplaces using safe materials and proper ventilation. 
                        Each design follows safety guidelines for heat and outdoor use.
                    </div>
                </div>
            </div>

            <!-- FAQ 4 -->
            <div class="card mb-3" style="border:none; border-radius:12px; box-shadow:0 4px 16px rgba(0,0,0,0.06);">
                <div class="card-header" id="fireFaq4" style="background:#fff; border-radius:12px;">
                    <h3 style="font-size:20px; font-weight:700; margin:0;">
                        <button class="btn btn-link collapsed text-dark"
                            type="button" data-toggle="collapse"
                            data-target="#fireAnswer4"
                            style="font-size:20px; font-weight:700; text-decoration:none;">
                            Can you match the fireplace to my home?
                        </button>
                    </h3>
                </div>

                <div id="fireAnswer4" class="collapse" data-parent="#fireplaceFaqAccordion">
                    <div class="card-body" style="padding:20px 25px; color:#444; line-height:1.7;">
                        Yes — we can match colors, stone, brick, and design styles so the 
                        fireplace blends naturally with your home and landscape.
                    </div>
                </div>
            </div>

        </div>

    </div>
</section>
