<!-- HERO SECTION – OUTDOOR LIVING SPACES -->
<section style="background:#e9f7e9; padding:90px 0; text-align:center;">
    <div class="container" style="max-width:760px;">
        
        <h1 style="
            font-size:46px;
            font-weight:800;
            color:#075818;
            margin-bottom:20px;
        ">
            Outdoor Living Spaces & Backyard Design
        </h1>

        <p style="
            font-size:18px;
            color:#223322;
            line-height:1.7;
        ">
            Aversa Outdoor builds patios, seating areas, walkways, and custom outdoor spaces 
            designed for style, comfort, and everyday living. Enjoy a space that feels natural, 
            clean, and perfect for gathering with family and friends.
        </p>
    </div>
</section>



<!-- SERVICE DETAILS SECTION -->
<section style="padding:70px 0; background:#fff;">
    <div class="container" style="max-width:900px;">

        <h2 style="color:#075818; font-weight:700; text-align:center; margin-bottom:40px;">
            Why Create an Outdoor Living Space?
        </h2>

        <p style="font-size:17px; color:#444; line-height:1.7; margin-bottom:30px;">
            A well-designed outdoor space turns your yard into a relaxing, usable area all year long. 
            Whether you want a quiet place to sit or a full area for hosting guests, we build 
            outdoor spaces that stay beautiful, functional, and easy to enjoy.
        </p>

        <div class="row">

            <!-- Benefit 1 -->
            <div class="col-md-4 mb-4">
                <div style="
                    background:#f6fbf6;
                    padding:25px;
                    border-radius:14px;
                    height:100%;
                    text-align:center;
                    border:1px solid rgba(0,0,0,0.06);
                ">
                    <h3 style="color:#075818; font-size:20px; font-weight:700; margin-bottom:10px;">
                        More Usable Space
                    </h3>
                    <p style="color:#555; font-size:15px;">
                        Turn open yard space into areas for relaxing, dining, or hosting.
                    </p>
                </div>
            </div>

            <!-- Benefit 2 -->
            <div class="col-md-4 mb-4">
                <div style="
                    background:#f6fbf6;
                    padding:25px;
                    border-radius:14px;
                    height:100%;
                    text-align:center;
                    border:1px solid rgba(0,0,0,0.06);
                ">
                    <h3 style="color:#075818; font-size:20px; font-weight:700; margin-bottom:10px;">
                        Clean, Modern Look
                    </h3>
                    <p style="color:#555; font-size:15px;">
                        Add style and structure that improves your entire outdoor layout.
                    </p>
                </div>
            </div>

            <!-- Benefit 3 -->
            <div class="col-md-4 mb-4">
                <div style="
                    background:#f6fbf6;
                    padding:25px;
                    border-radius:14px;
                    height:100%;
                    text-align:center;
                    border:1px solid rgba(0,0,0,0.06);
                ">
                    <h3 style="color:#075818; font-size:20px; font-weight:700; margin-bottom:10px;">
                        Custom to Your Home
                    </h3>
                    <p style="color:#555; font-size:15px;">
                        Built to match your space, your needs, and your home’s style.
                    </p>
                </div>
            </div>

        </div>

        <div style="height:20px;"></div>

        <h2 style="
            color:#075818;
            font-weight:700;
            margin-bottom:15px;
            text-align:center;
        ">
            Outdoor Living Features We Build
        </h2>

        <div style="display:flex; justify-content:center;">
            <ul style="
                color:#444;
                font-size:17px;
                line-height:1.7;
                list-style:none;
                padding:0;
                margin:0;
                text-align:center;
            ">
                <li>Custom patios & seating areas</li>
                <li>Walkways & outdoor pathways</li>
                <li>Lounge and dining areas</li>
                <li>Fire pits and outdoor fireplaces</li>
                <li>Outdoor kitchens (optional custom builds)</li>
                <li>Integrated planting and landscape design</li>
            </ul>
        </div>

    </div>
</section>



<!-- CTA SECTION -->
<section style="background:#e9f7e9; padding:80px 0;">
    <div class="container text-center" style="max-width:760px;">

        <h2 style="color:#075818; font-weight:700; font-size:36px; margin-bottom:20px;">
            Ready to Transform Your Outdoor Space?
        </h2>

        <p style="color:#444; font-size:18px; line-height:1.6; margin-bottom:32px;">
            From patios and seating areas to complete outdoor layouts, our team designs and 
            builds outdoor spaces made for comfort, beauty, and everyday use.
        </p>

        <div class="hero-cta-wrap" style="
            margin-top:25px;
            display:flex;
            gap:10px;
            align-items:center;
            justify-content:center;
            flex-wrap:wrap;
        ">
            <!-- Quote Button -->
            <a class="open-quote"
               style="
                   background:#34a906;
                   color:#fff;
                   padding:16px 40px;
                   border-radius:30px;
                   font-size:18px;
                   font-weight:600;
                   text-decoration:none;
                   transition:0.2s ease;
               "
               onmouseover="this.style.background='#2a9005'"
               onmouseout="this.style.background='#34a906'">
                Get a Free Quote
            </a>

            <!-- Call Button -->
            <a href="tel:9412741505"
               style="
                   background:#ffffff;
                   color:#34a906;
                   border:2px solid #34a906;
                   padding:12px 20px;
                   border-radius:50px;
                   font-weight:600;
                   font-size:16px;
                   text-decoration:none;
                   display:flex;
                   align-items:center;
                   gap:7px;
               ">
                <i class="bi bi-telephone-fill"></i> Call Now
            </a>
        </div>

    </div>


    <!-- GOOGLE MAPS -->
    <div class="container" style="margin-top:50px;">
        <div class="row">
            <div class="col-12">

                <h3 style="color:#075818; font-weight:700; font-size:26px; text-align:center; margin-bottom:20px;">
                    Visit or Contact Us
                </h3>

                <div style="
                    width:100%;
                    height:420px;
                    border-radius:16px;
                    overflow:hidden;
                    box-shadow:0 12px 32px rgba(0,0,0,0.15);
                ">
                    <iframe 
                        src="https://www.google.com/maps/embed?pb=!1m18!1m12!1m3!1d3539.1410893165043!2d-82.53450392454009!3d27.495987276304366!2m3!1f0!2f0!3f0!3m2!1i1024!2i768!4f13.1!3m3!1m2!1s0x88c317ab6e4454e9%3A0xcf58aaff67a401b4!2sAversa%20Outdoor!5e0!3m2!1sen!2sus!4v1765411553324!5m2!1sen!2sus"
                        width="100%"
                        height="100%"
                        style="border:0;"
                        allowfullscreen=""
                        loading="lazy">
                    </iframe>
                </div>

            </div>
        </div>
    </div>
</section>



<!-- OUTDOOR LIVING SPACES – FAQ SECTION -->
<section style="padding:80px 0; background:#f6fbf6;">
    <div class="container">

        <div class="text-center mx-md-auto mb-5 mb-md-7" style="max-width:760px;">
            <h2 style="color:#075818; font-weight:700;">
                Outdoor Living Spaces FAQs
            </h2>
            <p style="color:#555; font-size:18px; margin-top:10px;">
                Helpful answers to common questions about outdoor living design and construction.
            </p>
        </div>

        <div class="accordion" id="outdoorLivingFaqAccordion">

            <!-- FAQ 1 -->
            <div class="card mb-3" style="border:none; border-radius:12px; box-shadow:0 4px 16px rgba(0,0,0,0.06);">
                <div class="card-header" id="olFaq1" style="background:#fff; border-radius:12px;">
                    <h3 style="font-size:20px; font-weight:700; margin:0;">
                        <button class="btn btn-link collapsed text-dark"
                            type="button"
                            data-toggle="collapse"
                            data-target="#olAnswer1"
                            style="font-size:20px; font-weight:700; text-decoration:none;">
                            What counts as an outdoor living space?
                        </button>
                    </h3>
                </div>

                <div id="olAnswer1" class="collapse" data-parent="#outdoorLivingFaqAccordion">
                    <div class="card-body" style="padding:20px 25px; color:#444; line-height:1.7;">
                        Outdoor living spaces include patios, seating areas, walkways, dining areas, 
                        fire pits, lounges, and custom built spaces designed for comfort and style.
                    </div>
                </div>
            </div>

            <!-- FAQ 2 -->
            <div class="card mb-3" style="border:none; border-radius:12px; box-shadow:0 4px 16px rgba(0,0,0,0.06);">
                <div class="card-header" id="olFaq2" style="background:#fff; border-radius:12px;">
                    <h3 style="font-size:20px; font-weight:700; margin:0;">
                        <button class="btn btn-link collapsed text-dark"
                            type="button"
                            data-toggle="collapse"
                            data-target="#olAnswer2"
                            style="font-size:20px; font-weight:700; text-decoration:none;">
                            Can you design a full backyard layout?
                        </button>
                    </h3>
                </div>

                <div id="olAnswer2" class="collapse" data-parent="#outdoorLivingFaqAccordion">
                    <div class="card-body" style="padding:20px 25px; color:#444; line-height:1.7;">
                        Yes! We design full outdoor layouts, including patios, walkways, lounges, 
                        planting, and hardscapes that work together as one clean design.
                    </div>
                </div>
            </div>

            <!-- FAQ 3 -->
            <div class="card mb-3" style="border:none; border-radius:12px; box-shadow:0 4px 16px rgba(0,0,0,0.06);">
                <div class="card-header" id="olFaq3" style="background:#fff; border-radius:12px;">
                    <h3 style="font-size:20px; font-weight:700; margin:0;">
                        <button class="btn btn-link collapsed text-dark"
                            type="button"
                            data-toggle="collapse"
                            data-target="#olAnswer3"
                            style="font-size:20px; font-weight:700; text-decoration:none;">
                            What materials can be used for outdoor living spaces?
                        </button>
                    </h3>
                </div>

                <div id="olAnswer3" class="collapse" data-parent="#outdoorLivingFaqAccordion">
                    <div class="card-body" style="padding:20px 25px; color:#444; line-height:1.7;">
                        We build using pavers, stone, concrete, wood-style materials, and other 
                        durable options based on the look you want.
                    </div>
                </div>
            </div>

        </div>

    </div>
</section>
